/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.model;

import kieker.analysis.stage.model.AbstractSourceModelAssembler;
import kieker.analysis.stage.model.data.OperationEvent;
import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.assembly.AssemblyOperation;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.sources.SourceModel;

public class DeploymentModelAssembler
extends AbstractSourceModelAssembler {
    private final DeploymentFactory factory = DeploymentFactory.eINSTANCE;
    private final AssemblyModel assemblyModel;
    private final DeploymentModel deploymentModel;

    public DeploymentModelAssembler(AssemblyModel assemblyModel, DeploymentModel deploymentModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.assemblyModel = assemblyModel;
        this.deploymentModel = deploymentModel;
    }

    public void addOperation(OperationEvent event) {
        String hostname = event.getHostname();
        String classSignature = event.getComponentSignature();
        String operationSignature = event.getOperationSignature();
        this.addOperation(hostname, classSignature, operationSignature);
    }

    private void addOperation(String hostname, String componentSignature, String operationSignature) {
        DeploymentContext deploymentContext = this.addDeploymentContext(hostname);
        DeployedComponent component = this.addDeployedComponent(deploymentContext, componentSignature);
        this.addDeployedOperation(component, operationSignature);
    }

    private DeploymentContext addDeploymentContext(String hostname) {
        String deploymentContextKey = hostname;
        DeploymentContext deploymentContext = (DeploymentContext)this.deploymentModel.getDeploymentContexts().get((Object)deploymentContextKey);
        if (deploymentContext == null) {
            deploymentContext = this.factory.createDeploymentContext();
            deploymentContext.setName(hostname);
            this.deploymentModel.getDeploymentContexts().put((Object)deploymentContextKey, (Object)deploymentContext);
        }
        this.updateSourceModel(deploymentContext);
        return deploymentContext;
    }

    private DeployedComponent addDeployedComponent(DeploymentContext deploymentContext, String componentSignature) {
        String componentKey = componentSignature;
        DeployedComponent component = (DeployedComponent)deploymentContext.getComponents().get((Object)componentKey);
        if (component == null) {
            component = this.factory.createDeployedComponent();
            deploymentContext.getComponents().put((Object)componentKey, (Object)component);
            String componentTypeKey = componentSignature;
            AssemblyComponent assemblyComponent = (AssemblyComponent)this.assemblyModel.getAssemblyComponents().get((Object)componentTypeKey);
            component.setAssemblyComponent(assemblyComponent);
        }
        this.updateSourceModel(component);
        return component;
    }

    private DeployedOperation addDeployedOperation(DeployedComponent component, String operationSignature) {
        String operationKey = operationSignature;
        DeployedOperation operation = (DeployedOperation)component.getContainedOperations().get((Object)operationKey);
        if (operation == null) {
            operation = this.factory.createDeployedOperation();
            component.getContainedOperations().put((Object)operationKey, (Object)operation);
            AssemblyComponent assemblyComponent = component.getAssemblyComponent();
            String operationTypeKey = operationSignature;
            AssemblyOperation assemblyOperation = (AssemblyOperation)assemblyComponent.getAssemblyOperations().get((Object)operationTypeKey);
            operation.setAssemblyOperation(assemblyOperation);
        }
        this.updateSourceModel(operation);
        return operation;
    }
}

