/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics.calculating;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kieker.analysis.statistics.calculating.ICalculator;
import kieker.analysis.util.RunningMedian;
import kieker.model.analysismodel.statistics.EPropertyType;
import kieker.model.analysismodel.statistics.StatisticRecord;
import org.eclipse.emf.ecore.EObject;

public class MedianCalculator<T>
implements ICalculator<T> {
    private final Map<EObject, RunningMedian<Long>> runningMedians = new HashMap<EObject, RunningMedian<Long>>();
    private final Function<T, Long> valueAccessor;

    public MedianCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(StatisticRecord statistic, T input, EObject modelObject) {
        RunningMedian runningMedian = this.runningMedians.computeIfAbsent(modelObject, o -> RunningMedian.forLong());
        runningMedian.add((Comparable)this.valueAccessor.apply(input));
        long newMedian = (Long)runningMedian.getMedian();
        statistic.getProperties().put((Object)EPropertyType.MEDIAN, (Object)newMedian);
    }
}

