/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.reconstruction;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kieker.analysis.trace.AbstractTraceProcessingStage;
import kieker.analysis.trace.execution.ExecutionEventProcessingException;
import kieker.common.util.dataformat.LoggingTimestampConverter;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.Execution;
import kieker.model.system.model.ExecutionTrace;
import kieker.model.system.model.InvalidExecutionTrace;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.exceptions.InvalidTraceException;
import teetime.framework.OutputPort;

public class TraceReconstructionStage
extends AbstractTraceProcessingStage<Execution> {
    private final OutputPort<MessageTrace> messageTraceOutputPort = this.createOutputPort(MessageTrace.class);
    private final OutputPort<ExecutionTrace> executionTraceOutputPort = this.createOutputPort(ExecutionTrace.class);
    private final OutputPort<InvalidExecutionTrace> invalidExecutionTraceOutputPort = this.createOutputPort(InvalidExecutionTrace.class);
    private final TimeUnit timeunit;
    private final Map<Long, ExecutionTrace> pendingTraces = new Hashtable<Long, ExecutionTrace>();
    private final Set<Long> invalidTraces = new TreeSet<Long>();
    private volatile long minTin = -1L;
    private volatile long maxTout = -1L;
    private volatile boolean terminated;
    private final boolean ignoreInvalidTraces;
    private final long maxTraceDuration;
    private boolean traceProcessingErrorOccured;
    private final NavigableSet<ExecutionTrace> timeoutMap = new TreeSet<ExecutionTrace>(new Comparator<ExecutionTrace>(){

        @Override
        public int compare(ExecutionTrace t1, ExecutionTrace t2) {
            long t2LowestTin;
            if (t1 == t2) {
                return 0;
            }
            long t1LowestTin = t1.getTraceAsSortedExecutionSet().first().getTin();
            if (t1LowestTin != (t2LowestTin = t2.getTraceAsSortedExecutionSet().first().getTin())) {
                return t1LowestTin < t2LowestTin ? -1 : 1;
            }
            return t1.getTraceId() < t2.getTraceId() ? -1 : 1;
        }
    });

    public TraceReconstructionStage(SystemModelRepository repository, TimeUnit timeunit, boolean ignoreInvalidTraces, Long maxTraceDuration) {
        super(repository);
        this.timeunit = timeunit;
        this.maxTraceDuration = this.timeunit.convert(maxTraceDuration == null ? Long.MAX_VALUE : maxTraceDuration, timeunit);
        this.ignoreInvalidTraces = ignoreInvalidTraces;
        if (this.maxTraceDuration < 0L) {
            throw new IllegalArgumentException("value maxTraceDurationMillis must not be negative (found: " + this.maxTraceDuration + ")");
        }
    }

    public Set<Long> getInvalidTraces() {
        return this.invalidTraces;
    }

    public final long getMinTin() {
        return this.minTin;
    }

    public final long getMaxTout() {
        return this.maxTout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Execution execution) throws Exception {
        TraceReconstructionStage traceReconstructionStage = this;
        synchronized (traceReconstructionStage) {
            if (this.terminated || this.traceProcessingErrorOccured && !this.ignoreInvalidTraces) {
                return;
            }
            long traceId = execution.getTraceId();
            this.minTin = this.minTin < 0L || execution.getTin() < this.minTin ? execution.getTin() : this.minTin;
            this.maxTout = execution.getTout() > this.maxTout ? execution.getTout() : this.maxTout;
            ExecutionTrace executionTrace = this.pendingTraces.get(traceId);
            if (executionTrace != null) {
                if (!this.timeoutMap.remove(executionTrace)) {
                    this.logger.error("Missing entry for trace in timeoutMap: {} PendingTraces and timeoutMap are now longer consistent!", (Object)executionTrace);
                    this.reportError(traceId);
                }
            } else {
                executionTrace = new ExecutionTrace(traceId, execution.getSessionId());
                this.pendingTraces.put(traceId, executionTrace);
            }
            try {
                executionTrace.add(execution);
                if (!this.timeoutMap.add(executionTrace)) {
                    this.logger.error("Equal entry existed in timeoutMap already: {}", (Object)executionTrace);
                }
                this.processTimeoutQueue();
            }
            catch (InvalidTraceException ex) {
                this.logger.error("Attempt to add record to wrong trace", (Throwable)ex);
            }
            catch (ExecutionEventProcessingException ex) {
                this.logger.error("ExecutionEventProcessingException occured while processing the timeout queue.", (Throwable)ex);
            }
        }
    }

    private void processExecutionTrace(ExecutionTrace executionTrace) throws ExecutionEventProcessingException {
        long curTraceId = executionTrace.getTraceId();
        try {
            MessageTrace messageTrace = executionTrace.toMessageTrace(SystemModelRepository.ROOT_EXECUTION);
            if (!this.invalidTraces.contains(messageTrace.getTraceId())) {
                this.messageTraceOutputPort.send((Object)messageTrace);
                this.executionTraceOutputPort.send((Object)executionTrace);
                this.reportSuccess(curTraceId);
            } else {
                this.invalidExecutionTraceOutputPort.send((Object)new InvalidExecutionTrace(executionTrace));
            }
        }
        catch (InvalidTraceException ex) {
            this.invalidExecutionTraceOutputPort.send((Object)new InvalidExecutionTrace(executionTrace));
            String transformationError = "Failed to transform execution trace to message trace (ID: " + curTraceId + "). \nReason: " + ex.getMessage() + "\n Trace: " + executionTrace;
            if (!this.invalidTraces.contains(curTraceId)) {
                this.reportError(curTraceId);
                this.invalidTraces.add(curTraceId);
                if (!this.ignoreInvalidTraces) {
                    this.traceProcessingErrorOccured = true;
                    this.logger.warn("Filter was configured to terminate at the *first* invalid trace.");
                    throw new ExecutionEventProcessingException(transformationError, ex);
                }
                this.logger.error(transformationError);
            }
            this.logger.warn("Found additional fragment for trace already marked invalid: {}", (Object)transformationError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeoutQueue() throws ExecutionEventProcessingException {
        NavigableSet<ExecutionTrace> navigableSet = this.timeoutMap;
        synchronized (navigableSet) {
            while (!this.timeoutMap.isEmpty() && (this.terminated || this.maxTout - ((ExecutionTrace)this.timeoutMap.first()).getMinTin() > this.maxTraceDuration)) {
                ExecutionTrace polledTrace = this.timeoutMap.pollFirst();
                long curTraceId = polledTrace.getTraceId();
                this.pendingTraces.remove(curTraceId);
                this.processExecutionTrace(polledTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMaxTraceDuration() {
        TraceReconstructionStage traceReconstructionStage = this;
        synchronized (traceReconstructionStage) {
            return this.maxTraceDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        TraceReconstructionStage traceReconstructionStage = this;
        synchronized (traceReconstructionStage) {
            try {
                this.terminated = true;
                this.processTimeoutQueue();
            }
            catch (ExecutionEventProcessingException ex) {
                this.traceProcessingErrorOccured = true;
                this.logger.error("Error processing timeout queue: {}", (Throwable)ex);
            }
        }
        super.onTerminating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        TraceReconstructionStage traceReconstructionStage = this;
        synchronized (traceReconstructionStage) {
            super.printStatusMessage();
            if (this.getSuccessCount() > 0 || this.getErrorCount() > 0) {
                String minTinStr = this.minTin + " (" + LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.timeunit.toNanos(this.minTin)) + ',' + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(this.minTin) + ')';
                String maxToutStr = this.maxTout + " (" + LoggingTimestampConverter.convertLoggingTimestampToUTCString(this.timeunit.toNanos(this.maxTout)) + ',' + LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(this.maxTout) + ')';
                this.logger.debug("First timestamp: {}", (Object)minTinStr);
                this.logger.debug("Last timestamp: {}", (Object)maxToutStr);
            }
        }
    }

    public OutputPort<MessageTrace> getMessageTraceOutputPort() {
        return this.messageTraceOutputPort;
    }

    public OutputPort<ExecutionTrace> getExecutionTraceOutputPort() {
        return this.executionTraceOutputPort;
    }

    public OutputPort<InvalidExecutionTrace> getInvalidExecutionTraceOutputPort() {
        return this.invalidExecutionTraceOutputPort;
    }
}

