/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.fsReader;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.util.filesystem.FileExtensionFilter;
import org.slf4j.Logger;

@Deprecated
abstract class AbstractLogReaderThread
extends Thread {
    private final Logger logger;
    private final File inputDir;
    private volatile boolean shouldTerminate;

    protected AbstractLogReaderThread(Logger logger, File inputDir) {
        this.logger = logger;
        this.inputDir = inputDir;
    }

    @Override
    public final void run() {
        this.readMappingFile();
        FileExtensionFilter fileExtensionFilter = this.getFileExtensionFilter();
        File[] inputFiles = this.inputDir.listFiles(fileExtensionFilter);
        if (inputFiles == null) {
            this.logger.error("Directory '" + this.inputDir + "' does not exist or an I/O error occured.");
        } else if (inputFiles.length == 0) {
            this.logger.warn("Directory '" + this.inputDir + "' contains no Kieker log files.");
        } else {
            Arrays.sort(inputFiles, new Comparator<File>(){

                @Override
                public final int compare(File f1, File f2) {
                    return f1.compareTo(f2);
                }
            });
            for (File inputFile : inputFiles) {
                if (this.shouldTerminate) {
                    this.logger.info("Shutting down DirectoryReader.");
                    break;
                }
                this.logger.info("< Loading " + inputFile.getAbsolutePath());
                try {
                    this.processNormalInputFile(inputFile);
                }
                catch (RecordInstantiationException e) {
                    break;
                }
            }
        }
        this.onEndOfRun();
    }

    protected abstract FileExtensionFilter getFileExtensionFilter();

    protected abstract void readMappingFile();

    protected abstract void processNormalInputFile(File var1);

    protected abstract void onEndOfRun();

    public void terminate() {
        this.shouldTerminate = true;
        this.interrupt();
    }
}

