/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.jms;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import kieker.common.record.IMonitoringRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class JMSReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSReader.class);
    private final String jmsProviderUrl;
    private final String jmsDestination;
    private final String jmsFactoryLookupName;
    private final CountDownLatch cdLatch = new CountDownLatch(1);
    private final Consumer<IMonitoringRecord> elementReceivedCallback;

    public JMSReader(String jmsProviderUrl, String jmsDestination, String jmsFactoryLookupName, Consumer<IMonitoringRecord> elementReceivedCallback) throws IllegalArgumentException {
        this.jmsProviderUrl = jmsProviderUrl;
        this.jmsDestination = jmsDestination;
        this.jmsFactoryLookupName = jmsFactoryLookupName;
        this.elementReceivedCallback = elementReceivedCallback;
        if (this.jmsProviderUrl.length() == 0 || this.jmsDestination.length() == 0 || this.jmsFactoryLookupName.length() == 0) {
            String message = String.format("Invalid or incomplete parameters: jmsProviderUrl ('%s'), jmsDestination ('%s'), or factoryLookupName ('%s') is null", this.jmsProviderUrl, this.jmsDestination, this.jmsFactoryLookupName);
            throw new IllegalArgumentException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        boolean retVal = true;
        Connection connection = null;
        try {
            Destination destination;
            Session session;
            block14: {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("java.naming.factory.initial", this.jmsFactoryLookupName);
                properties.put("java.naming.provider.url", this.jmsProviderUrl);
                InitialContext context = new InitialContext(properties);
                ConnectionFactory factory = (ConnectionFactory)context.lookup("ConnectionFactory");
                connection = factory.createConnection();
                session = connection.createSession(false, 1);
                try {
                    destination = (Destination)context.lookup(this.jmsDestination);
                }
                catch (NameNotFoundException exc) {
                    destination = session.createQueue(this.jmsDestination);
                    if (destination != null) break block14;
                    LOGGER.error("Failed to lookup queue '{}' via JNDI: {} AND failed to create queue", (Object)this.jmsDestination, (Object)exc.getMessage());
                    throw exc;
                }
            }
            LOGGER.info("Listening to destination: {} at {} !\n***\n\n", (Object)destination, (Object)this.jmsProviderUrl);
            MessageConsumer receiver = session.createConsumer(destination);
            receiver.setMessageListener((MessageListener)new JMSMessageListener());
            connection.start();
            LOGGER.info("JMSReader started and waits for incoming monitoring events!");
            this.block();
            LOGGER.info("Woke up by shutdown");
        }
        catch (Exception ex) {
            LOGGER.error("Error in read()", (Throwable)ex);
            retVal = false;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (JMSException ex) {
                LOGGER.error("Failed to close JMS", (Throwable)ex);
            }
        }
        return retVal;
    }

    private final void block() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public final void run() {
                JMSReader.this.unblock();
            }
        });
        try {
            this.cdLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    final void unblock() {
        this.cdLatch.countDown();
    }

    final void deliverIndirect(IMonitoringRecord data) {
        this.elementReceivedCallback.accept(data);
    }

    public void terminate() {
        LOGGER.info("Shutdown of JMSReader requested.");
        this.unblock();
    }

    Logger getLogger() {
        return LOGGER;
    }

    private final class JMSMessageListener
    implements MessageListener {
        public void onMessage(Message jmsMessage) {
            if (jmsMessage == null) {
                JMSReader.this.getLogger().warn("Received null message");
            } else if (jmsMessage instanceof ObjectMessage) {
                try {
                    ObjectMessage om = (ObjectMessage)jmsMessage;
                    Serializable omo = om.getObject();
                    if (omo instanceof IMonitoringRecord) {
                        JMSReader.this.deliverIndirect((IMonitoringRecord)omo);
                    }
                }
                catch (MessageFormatException ex) {
                    JMSReader.this.getLogger().error("Error delivering record", (Throwable)ex);
                }
                catch (JMSException ex) {
                    JMSReader.this.getLogger().error("Error delivering record", (Throwable)ex);
                }
                catch (Exception ex) {
                    JMSReader.this.getLogger().error("Error delivering record", (Throwable)ex);
                }
            } else {
                JMSReader.this.getLogger().warn("Received message of invalid type: {}", (Object)jmsMessage.getClass().getName());
            }
        }
    }
}

