/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.concurrency.monitor;

import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.io.IValueDeserializer;

public abstract class AbstractMonitorEvent
extends AbstractTraceEvent {
    public static final int LOCK_ID = 0;
    private static final long serialVersionUID = -5428034537740978080L;
    private final int lockId;

    public AbstractMonitorEvent(long timestamp, long traceId, int orderIndex, int lockId) {
        super(timestamp, traceId, orderIndex);
        this.lockId = lockId;
    }

    public AbstractMonitorEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.lockId = deserializer.getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMonitorEvent castedRecord = (AbstractMonitorEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        return this.getLockId() == castedRecord.getLockId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        return code += this.getLockId();
    }

    public final int getLockId() {
        return this.lockId;
    }

    @Override
    public String toString() {
        String result = "AbstractMonitorEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "lockId = ";
        result = result + this.getLockId() + ", ";
        return result;
    }
}

