/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.remotecontrol;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.remotecontrol.IRemoteParameterControlEvent;

public class UpdateParameterEvent
extends AbstractMonitoringRecord
implements IRemoteParameterControlEvent {
    public static final int SIZE = 12;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String[].class};
    public static final String[] VALUE_NAMES = new String[]{"pattern", "name", "values"};
    public static final String PATTERN = "";
    public static final String NAME = "";
    private static final long serialVersionUID = -6620482545947972483L;
    private final String pattern;
    private final String name;
    private final String[] values;

    public UpdateParameterEvent(String pattern, String name, String[] values) {
        this.pattern = pattern == null ? "" : pattern;
        this.name = name == null ? "" : name;
        this.values = values;
    }

    public UpdateParameterEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.pattern = deserializer.getString();
        this.name = deserializer.getString();
        int _values_size0 = deserializer.getInt();
        this.values = new String[_values_size0];
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            this.values[i0] = deserializer.getString();
        }
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getPattern());
        serializer.putString(this.getName());
        int _values_size0 = this.getValues().length;
        serializer.putInt(_values_size0);
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            serializer.putString(this.getValues()[i0]);
        }
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UpdateParameterEvent castedRecord = (UpdateParameterEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (!this.getPattern().equals(castedRecord.getPattern())) {
            return false;
        }
        if (!this.getName().equals(castedRecord.getName())) {
            return false;
        }
        int _values_size0 = this.getValues().length;
        if (_values_size0 != castedRecord.getValues().length) {
            return false;
        }
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            if (this.getValues()[i0].equals(castedRecord.getValues()[i0])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getPattern().hashCode();
        code += this.getName().hashCode();
        for (int i0 = 0; i0 < this.values.length; ++i0) {
            for (int i1 = 0; i1 < this.values.length; ++i1) {
                code += this.getValues()[i0].hashCode();
            }
        }
        return code;
    }

    @Override
    public final String getPattern() {
        return this.pattern;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String[] getValues() {
        return this.values;
    }

    @Override
    public String toString() {
        String result = "UpdateParameterEvent: ";
        result = result + "pattern = ";
        result = result + this.getPattern() + ", ";
        result = result + "name = ";
        result = result + this.getName() + ", ";
        result = result + "values = ";
        int _values_size0 = this.getValues().length;
        result = result + "{ ";
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            result = result + this.getValues()[i0] + ", ";
        }
        result = result + " }";
        return result;
    }
}

