/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class NetworkUtilizationRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 128;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "interfaceName", "speed", "txBytesPerSecond", "txCarrierPerSecond", "txCollisionsPerSecond", "txDroppedPerSecond", "txErrorsPerSecond", "txOverrunsPerSecond", "txPacketsPerSecond", "rxBytesPerSecond", "rxDroppedPerSecond", "rxErrorsPerSecond", "rxFramePerSecond", "rxOverrunsPerSecond", "rxPacketsPerSecond"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String INTERFACE_NAME = "";
    public static final long SPEED = 0L;
    public static final double TX_BYTES_PER_SECOND = 0.0;
    public static final double TX_CARRIER_PER_SECOND = 0.0;
    public static final double TX_COLLISIONS_PER_SECOND = 0.0;
    public static final double TX_DROPPED_PER_SECOND = 0.0;
    public static final double TX_ERRORS_PER_SECOND = 0.0;
    public static final double TX_OVERRUNS_PER_SECOND = 0.0;
    public static final double TX_PACKETS_PER_SECOND = 0.0;
    public static final double RX_BYTES_PER_SECOND = 0.0;
    public static final double RX_DROPPED_PER_SECOND = 0.0;
    public static final double RX_ERRORS_PER_SECOND = 0.0;
    public static final double RX_FRAME_PER_SECOND = 0.0;
    public static final double RX_OVERRUNS_PER_SECOND = 0.0;
    public static final double RX_PACKETS_PER_SECOND = 0.0;
    private static final long serialVersionUID = 7799663712343478641L;
    private final long timestamp;
    private final String hostname;
    private final String interfaceName;
    private final long speed;
    private final double txBytesPerSecond;
    private final double txCarrierPerSecond;
    private final double txCollisionsPerSecond;
    private final double txDroppedPerSecond;
    private final double txErrorsPerSecond;
    private final double txOverrunsPerSecond;
    private final double txPacketsPerSecond;
    private final double rxBytesPerSecond;
    private final double rxDroppedPerSecond;
    private final double rxErrorsPerSecond;
    private final double rxFramePerSecond;
    private final double rxOverrunsPerSecond;
    private final double rxPacketsPerSecond;

    public NetworkUtilizationRecord(long timestamp, String hostname, String interfaceName, long speed, double txBytesPerSecond, double txCarrierPerSecond, double txCollisionsPerSecond, double txDroppedPerSecond, double txErrorsPerSecond, double txOverrunsPerSecond, double txPacketsPerSecond, double rxBytesPerSecond, double rxDroppedPerSecond, double rxErrorsPerSecond, double rxFramePerSecond, double rxOverrunsPerSecond, double rxPacketsPerSecond) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.interfaceName = interfaceName == null ? "" : interfaceName;
        this.speed = speed;
        this.txBytesPerSecond = txBytesPerSecond;
        this.txCarrierPerSecond = txCarrierPerSecond;
        this.txCollisionsPerSecond = txCollisionsPerSecond;
        this.txDroppedPerSecond = txDroppedPerSecond;
        this.txErrorsPerSecond = txErrorsPerSecond;
        this.txOverrunsPerSecond = txOverrunsPerSecond;
        this.txPacketsPerSecond = txPacketsPerSecond;
        this.rxBytesPerSecond = rxBytesPerSecond;
        this.rxDroppedPerSecond = rxDroppedPerSecond;
        this.rxErrorsPerSecond = rxErrorsPerSecond;
        this.rxFramePerSecond = rxFramePerSecond;
        this.rxOverrunsPerSecond = rxOverrunsPerSecond;
        this.rxPacketsPerSecond = rxPacketsPerSecond;
    }

    public NetworkUtilizationRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.interfaceName = deserializer.getString();
        this.speed = deserializer.getLong();
        this.txBytesPerSecond = deserializer.getDouble();
        this.txCarrierPerSecond = deserializer.getDouble();
        this.txCollisionsPerSecond = deserializer.getDouble();
        this.txDroppedPerSecond = deserializer.getDouble();
        this.txErrorsPerSecond = deserializer.getDouble();
        this.txOverrunsPerSecond = deserializer.getDouble();
        this.txPacketsPerSecond = deserializer.getDouble();
        this.rxBytesPerSecond = deserializer.getDouble();
        this.rxDroppedPerSecond = deserializer.getDouble();
        this.rxErrorsPerSecond = deserializer.getDouble();
        this.rxFramePerSecond = deserializer.getDouble();
        this.rxOverrunsPerSecond = deserializer.getDouble();
        this.rxPacketsPerSecond = deserializer.getDouble();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getInterfaceName());
        serializer.putLong(this.getSpeed());
        serializer.putDouble(this.getTxBytesPerSecond());
        serializer.putDouble(this.getTxCarrierPerSecond());
        serializer.putDouble(this.getTxCollisionsPerSecond());
        serializer.putDouble(this.getTxDroppedPerSecond());
        serializer.putDouble(this.getTxErrorsPerSecond());
        serializer.putDouble(this.getTxOverrunsPerSecond());
        serializer.putDouble(this.getTxPacketsPerSecond());
        serializer.putDouble(this.getRxBytesPerSecond());
        serializer.putDouble(this.getRxDroppedPerSecond());
        serializer.putDouble(this.getRxErrorsPerSecond());
        serializer.putDouble(this.getRxFramePerSecond());
        serializer.putDouble(this.getRxOverrunsPerSecond());
        serializer.putDouble(this.getRxPacketsPerSecond());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 128;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        NetworkUtilizationRecord castedRecord = (NetworkUtilizationRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (!this.getInterfaceName().equals(castedRecord.getInterfaceName())) {
            return false;
        }
        if (this.getSpeed() != castedRecord.getSpeed()) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxBytesPerSecond(), castedRecord.getTxBytesPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxCarrierPerSecond(), castedRecord.getTxCarrierPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxCollisionsPerSecond(), castedRecord.getTxCollisionsPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxDroppedPerSecond(), castedRecord.getTxDroppedPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxErrorsPerSecond(), castedRecord.getTxErrorsPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxOverrunsPerSecond(), castedRecord.getTxOverrunsPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getTxPacketsPerSecond(), castedRecord.getTxPacketsPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getRxBytesPerSecond(), castedRecord.getRxBytesPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getRxDroppedPerSecond(), castedRecord.getRxDroppedPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getRxErrorsPerSecond(), castedRecord.getRxErrorsPerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getRxFramePerSecond(), castedRecord.getRxFramePerSecond())) {
            return false;
        }
        if (NetworkUtilizationRecord.isNotEqual(this.getRxOverrunsPerSecond(), castedRecord.getRxOverrunsPerSecond())) {
            return false;
        }
        return !NetworkUtilizationRecord.isNotEqual(this.getRxPacketsPerSecond(), castedRecord.getRxPacketsPerSecond());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getInterfaceName().hashCode();
        code += (int)this.getSpeed();
        code += (int)this.getTxBytesPerSecond();
        code += (int)this.getTxCarrierPerSecond();
        code += (int)this.getTxCollisionsPerSecond();
        code += (int)this.getTxDroppedPerSecond();
        code += (int)this.getTxErrorsPerSecond();
        code += (int)this.getTxOverrunsPerSecond();
        code += (int)this.getTxPacketsPerSecond();
        code += (int)this.getRxBytesPerSecond();
        code += (int)this.getRxDroppedPerSecond();
        code += (int)this.getRxErrorsPerSecond();
        code += (int)this.getRxFramePerSecond();
        code += (int)this.getRxOverrunsPerSecond();
        return code += (int)this.getRxPacketsPerSecond();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getInterfaceName() {
        return this.interfaceName;
    }

    public final long getSpeed() {
        return this.speed;
    }

    public final double getTxBytesPerSecond() {
        return this.txBytesPerSecond;
    }

    public final double getTxCarrierPerSecond() {
        return this.txCarrierPerSecond;
    }

    public final double getTxCollisionsPerSecond() {
        return this.txCollisionsPerSecond;
    }

    public final double getTxDroppedPerSecond() {
        return this.txDroppedPerSecond;
    }

    public final double getTxErrorsPerSecond() {
        return this.txErrorsPerSecond;
    }

    public final double getTxOverrunsPerSecond() {
        return this.txOverrunsPerSecond;
    }

    public final double getTxPacketsPerSecond() {
        return this.txPacketsPerSecond;
    }

    public final double getRxBytesPerSecond() {
        return this.rxBytesPerSecond;
    }

    public final double getRxDroppedPerSecond() {
        return this.rxDroppedPerSecond;
    }

    public final double getRxErrorsPerSecond() {
        return this.rxErrorsPerSecond;
    }

    public final double getRxFramePerSecond() {
        return this.rxFramePerSecond;
    }

    public final double getRxOverrunsPerSecond() {
        return this.rxOverrunsPerSecond;
    }

    public final double getRxPacketsPerSecond() {
        return this.rxPacketsPerSecond;
    }

    @Override
    public String toString() {
        String result = "NetworkUtilizationRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "interfaceName = ";
        result = result + this.getInterfaceName() + ", ";
        result = result + "speed = ";
        result = result + this.getSpeed() + ", ";
        result = result + "txBytesPerSecond = ";
        result = result + this.getTxBytesPerSecond() + ", ";
        result = result + "txCarrierPerSecond = ";
        result = result + this.getTxCarrierPerSecond() + ", ";
        result = result + "txCollisionsPerSecond = ";
        result = result + this.getTxCollisionsPerSecond() + ", ";
        result = result + "txDroppedPerSecond = ";
        result = result + this.getTxDroppedPerSecond() + ", ";
        result = result + "txErrorsPerSecond = ";
        result = result + this.getTxErrorsPerSecond() + ", ";
        result = result + "txOverrunsPerSecond = ";
        result = result + this.getTxOverrunsPerSecond() + ", ";
        result = result + "txPacketsPerSecond = ";
        result = result + this.getTxPacketsPerSecond() + ", ";
        result = result + "rxBytesPerSecond = ";
        result = result + this.getRxBytesPerSecond() + ", ";
        result = result + "rxDroppedPerSecond = ";
        result = result + this.getRxDroppedPerSecond() + ", ";
        result = result + "rxErrorsPerSecond = ";
        result = result + this.getRxErrorsPerSecond() + ", ";
        result = result + "rxFramePerSecond = ";
        result = result + this.getRxFramePerSecond() + ", ";
        result = result + "rxOverrunsPerSecond = ";
        result = result + this.getRxOverrunsPerSecond() + ", ";
        result = result + "rxPacketsPerSecond = ";
        result = result + this.getRxPacketsPerSecond() + ", ";
        return result;
    }
}

