/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.filesystem;

import java.io.File;
import java.io.FilenameFilter;

public class FileExtensionFilter
implements FilenameFilter {
    public static final FileExtensionFilter BIN = new FileExtensionFilter(".bin");
    public static final FileExtensionFilter DAT = new FileExtensionFilter(".dat");
    public static final FileExtensionFilter DEFLATE = new FileExtensionFilter(".df");
    public static final FileExtensionFilter GZIP = new FileExtensionFilter(".gz");
    public static final FileExtensionFilter MAP = new FileExtensionFilter(".map");
    public static final FileExtensionFilter XZ = new FileExtensionFilter(".xz");
    public static final FileExtensionFilter ZIP = new FileExtensionFilter(".zip");
    private final String fileExtension;

    public FileExtensionFilter(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (!name.startsWith("kieker")) {
            return false;
        }
        return name.endsWith(this.fileExtension);
    }

    public String getExtensionName() {
        return this.fileExtension;
    }
}

