/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.signaturePattern;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;

public final class PatternParser {
    private static final String NON_NATIVE = "non_native";
    private static final String NATIVE = "native";
    private static final String NON_SYNCHRONIZED = "non_synchronized";
    private static final String SYNCHRONIZED = "synchronized";
    private static final String NON_FINAL = "non_final";
    private static final String FINAL = "final";
    private static final String NON_STATIC = "non_static";
    private static final String NON_ABSTRACT = "non_abstract";
    private static final String STATIC = "static";
    private static final String ABSTRACT = "abstract";
    private static final String PACKAGE = "package";
    private static final String MODIFIER_PROTECTED = "protected";
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_PUBLIC = "public";
    private static final String FULLY_QUALFIED_NAME = "[\\p{javaJavaIdentifierPart}\\.])*\\p{javaJavaIdentifierPart}+";
    private static final String SIMPLE_NAME = "(\\p{javaJavaIdentifierPart})+";
    private static final Map<String, Integer> ALLOWED_MODIFIER_WITH_ORDER = new HashMap<String, Integer>();

    private PatternParser() {
    }

    public static Pattern parseToPattern(String strPattern) throws InvalidPatternException {
        String trimPattern = strPattern.trim();
        if (trimPattern.charAt(0) == '%') {
            try {
                return Pattern.compile(trimPattern);
            }
            catch (PatternSyntaxException pse) {
                throw new InvalidPatternException("Invalid regular expression", pse);
            }
        }
        StringBuilder sb = new StringBuilder();
        if ("*".equals(trimPattern)) {
            sb.append(".*");
        } else {
            String fqName;
            int index;
            int openingParenthesis = trimPattern.indexOf(40);
            int closingParenthesis = trimPattern.indexOf(41);
            if (openingParenthesis == -1 || closingParenthesis == -1 || openingParenthesis != trimPattern.lastIndexOf(40) || closingParenthesis != trimPattern.lastIndexOf(41) || openingParenthesis > closingParenthesis) {
                throw new InvalidPatternException("Invalid parentheses");
            }
            String[] modifierList = null;
            String[] tokens = trimPattern.substring(0, openingParenthesis).trim().split("\\s+");
            int numOfModifiers = tokens.length - 2;
            if (tokens.length > 2) {
                modifierList = new String[numOfModifiers];
                System.arraycopy(tokens, 0, modifierList, 0, numOfModifiers);
            }
            if ((index = (fqName = tokens[numOfModifiers + 1]).lastIndexOf(46)) == -1 || index == fqName.length() - 1) {
                throw new InvalidPatternException("Invalid fully qualified type or method name.");
            }
            String fqClassName = fqName.substring(0, index);
            String methodName = fqName.substring(index + 1);
            if ("new".equals(tokens[numOfModifiers]) && !"<init>".equals(methodName)) {
                throw new InvalidPatternException("Invalid constructor name - must always be <init>");
            }
            String params = trimPattern.substring(openingParenthesis + 1, closingParenthesis).trim();
            int throwsPatternStart = closingParenthesis + 1;
            String throwsPattern = throwsPatternStart < trimPattern.length() ? trimPattern.substring(throwsPatternStart) : null;
            sb.append(PatternParser.parseModifierConstraintList(modifierList));
            sb.append(PatternParser.parseRetType(tokens[numOfModifiers]));
            sb.append(PatternParser.parseFQClassname(fqClassName));
            sb.append("\\.");
            sb.append(PatternParser.parseMethodName(methodName));
            sb.append("\\(");
            sb.append(PatternParser.parseParameterList(PatternParser.trimValues(params.trim().split(","))));
            sb.append("\\)");
            sb.append(PatternParser.parseThrowsPattern(throwsPattern));
        }
        return Pattern.compile(sb.toString());
    }

    private static String[] trimValues(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    private static String parseMethodName(String methodName) throws InvalidPatternException {
        try {
            if ("<init>".equals(methodName)) {
                return "<init>";
            }
            return PatternParser.parseIdentifier(methodName);
        }
        catch (InvalidPatternException ex) {
            throw new InvalidPatternException("Invalid method name.", ex);
        }
    }

    private static String parseParameterList(String[] paramList) throws InvalidPatternException {
        if (paramList.length == 1) {
            if (paramList[0].length() == 0) {
                return "";
            }
            if ("..".equals(paramList[0])) {
                return ".*";
            }
        }
        return PatternParser.parseMultipleParameters(paramList);
    }

    private static String parseMultipleParameters(String[] paramList) throws InvalidPatternException {
        StringBuilder sb = new StringBuilder(255);
        int length = paramList.length;
        int start = 1;
        if ("..".equals(paramList[0])) {
            sb.append("(((\\s)?[\\p{javaJavaIdentifierPart}\\.])*\\p{javaJavaIdentifierPart}+(\\s)?,)*");
            if (length > 1) {
                start = 2;
                PatternParser.createParameterRegex(sb, paramList[1]);
            }
        } else if ("*".equals(paramList[0])) {
            sb.append("(\\s)?(\\p{javaJavaIdentifierPart})+(\\s)?");
        } else {
            if (paramList[0].length() == 0) {
                throw new InvalidPatternException("Invalid parameter list.");
            }
            try {
                sb.append("(\\s)?").append(PatternParser.parseFQClassname(paramList[0])).append("(\\s)?");
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid parameter list.", ex);
            }
        }
        for (int i = start; i < length; ++i) {
            PatternParser.createParameterRegex(sb, paramList[i]);
        }
        return sb.toString();
    }

    private static void createParameterRegex(StringBuilder regexBuilder, String parameter) throws InvalidPatternException {
        if ("..".equals(parameter)) {
            regexBuilder.append("(,?((\\s)?[\\p{javaJavaIdentifierPart}\\.])*\\p{javaJavaIdentifierPart}+(\\s)?)*");
        } else if ("*".equals(parameter)) {
            regexBuilder.append(",?(\\s)?(\\p{javaJavaIdentifierPart})+(\\s)?");
        } else {
            if (parameter.length() == 0) {
                throw new InvalidPatternException("Invalid parameter list.");
            }
            try {
                regexBuilder.append(",?(\\s)?");
                regexBuilder.append(PatternParser.parseFQClassname(parameter));
                regexBuilder.append("(\\s)?");
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid parameter list.", ex);
            }
        }
    }

    private static String parseType(String type) throws InvalidPatternException {
        int index = type.indexOf(91);
        if (index != -1) {
            String onlyIdentified = type.substring(0, index);
            String onlyArrayParenthesis = type.substring(index).replace("[", "\\[").replace("]", "\\]");
            return PatternParser.parseIdentifier(onlyIdentified) + onlyArrayParenthesis;
        }
        return PatternParser.parseIdentifier(type);
    }

    private static String parseIdentifier(String identifier) throws InvalidPatternException {
        char[] array = identifier.toCharArray();
        StringBuilder sb = new StringBuilder(128);
        if (Character.isJavaIdentifierStart(array[0])) {
            sb.append(Character.toString(array[0]));
        } else if (array[0] == '*') {
            sb.append("([\\p{javaJavaIdentifierPart}.])*");
        } else {
            throw new InvalidPatternException("Identifier starts with invalid symbol.");
        }
        for (int i = 1; i < array.length; ++i) {
            if (array[i] == '$') {
                sb.append("\\").append(array[i]);
                continue;
            }
            if (Character.isJavaIdentifierPart(array[i])) {
                sb.append(array[i]);
                continue;
            }
            if (array[i] == '*') {
                sb.append("(\\p{javaJavaIdentifierPart})*");
                continue;
            }
            throw new InvalidPatternException("Identifier includes invalid symbol.");
        }
        return sb.toString();
    }

    private static String parseFQClassname(String fqClassname) throws InvalidPatternException {
        if (fqClassname.contains("...") || fqClassname.endsWith(".") || fqClassname.length() == 0) {
            throw new InvalidPatternException("Invalid fully qualified type.");
        }
        String[] tokens = fqClassname.split("\\.");
        if (tokens.length == 1) {
            try {
                return PatternParser.parseType(fqClassname);
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid fully qualified type.", ex);
            }
        }
        return PatternParser.parseFQTypeTokenized(tokens);
    }

    private static String parseFQTypeTokenized(String[] tokens) throws InvalidPatternException {
        int start = 0;
        StringBuilder sb = new StringBuilder(128);
        if (tokens[0].length() == 0 && tokens[1].length() == 0) {
            sb.append("(([\\p{javaJavaIdentifierPart}\\.])*\\.)?");
            start = 2;
        } else if (tokens[0].length() == 0) {
            throw new InvalidPatternException("Invalid fully qualified type: leading dot");
        }
        int length = tokens.length;
        for (int i = start; i < length - 1; ++i) {
            if (tokens[i].length() == 0) {
                sb.append("(([\\p{javaJavaIdentifierPart}\\.])*\\.)?");
                continue;
            }
            try {
                sb.append(PatternParser.parseType(tokens[i]));
            }
            catch (InvalidPatternException ex) {
                throw new InvalidPatternException("Invalid fully qualified type.", ex);
            }
            sb.append("\\.");
        }
        try {
            sb.append(PatternParser.parseType(tokens[length - 1]));
        }
        catch (InvalidPatternException ex) {
            InvalidPatternException newEx = new InvalidPatternException("Invalid fully qualified type.");
            throw (InvalidPatternException)newEx.initCause(ex);
        }
        return sb.toString();
    }

    private static String parseRetType(String retType) throws InvalidPatternException {
        if ("new".equals(retType)) {
            return "(new\\s)?";
        }
        try {
            return PatternParser.parseFQClassname(retType) + "\\s";
        }
        catch (InvalidPatternException ex) {
            throw new InvalidPatternException("Invalid return type.", ex);
        }
    }

    private static String parseModifierConstraintList(String[] modifierList) throws InvalidPatternException {
        if (modifierList == null) {
            return "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?";
        }
        return PatternParser.parseNonEmptyModifierContraintList(modifierList);
    }

    private static String parseNonEmptyModifierContraintList(String[] modifierList) throws InvalidPatternException {
        int numberOfModifiers = modifierList.length;
        Integer old = -1;
        for (int i = 0; i < numberOfModifiers; ++i) {
            Integer current = ALLOWED_MODIFIER_WITH_ORDER.get(modifierList[i]);
            if (null == current || current < old) {
                throw new InvalidPatternException("Invalid modifier");
            }
            old = current;
        }
        StringBuilder sb = new StringBuilder();
        switch (numberOfModifiers) {
            case 1: {
                PatternParser.onOneModifier(modifierList, sb);
                break;
            }
            case 2: {
                PatternParser.onTwoModifiers(modifierList, sb);
                break;
            }
            case 3: {
                PatternParser.onThreeModifiers(modifierList, sb);
                break;
            }
            case 4: {
                PatternParser.onFourModifiers(modifierList, sb);
                break;
            }
            case 5: {
                PatternParser.onFiveModifiers(modifierList, sb);
                break;
            }
            case 6: {
                PatternParser.onSixModifiers(modifierList, sb);
                break;
            }
            default: {
                throw new InvalidPatternException("Too many modifier.");
            }
        }
        return sb.toString();
    }

    private static void onSixModifiers(String[] modifierList, StringBuilder sb) throws InvalidPatternException {
        PatternParser.appendScope(sb, modifierList[0], true);
        if (ABSTRACT.equals(modifierList[1])) {
            sb.append("abstract\\s");
        } else if (!NON_ABSTRACT.equals(modifierList[1])) {
            throw new InvalidPatternException("Invalid modifier.");
        }
        if (STATIC.equals(modifierList[2])) {
            sb.append("static\\s");
        } else if (!NON_STATIC.equals(modifierList[2])) {
            throw new InvalidPatternException("Invalid modifier.");
        }
        if (FINAL.equals(modifierList[3])) {
            sb.append("final\\s");
        } else if (!NON_FINAL.equals(modifierList[3])) {
            throw new InvalidPatternException("Invalid modifier.");
        }
        if (SYNCHRONIZED.equals(modifierList[4])) {
            sb.append("synchronized\\s");
        } else if (!NON_SYNCHRONIZED.equals(modifierList[4])) {
            throw new InvalidPatternException("Invalid modifier.");
        }
        PatternParser.checkNativeFail(sb, modifierList[5]);
    }

    private static void checkNativeFail(StringBuilder sb, String modifier) throws InvalidPatternException {
        if (NATIVE.equals(modifier)) {
            sb.append("native\\s");
        } else if (!NON_NATIVE.equals(modifier)) {
            throw new InvalidPatternException("Invalid modifier.");
        }
    }

    private static void onFiveModifiers(String[] modifierList, StringBuilder sb) throws InvalidPatternException {
        PatternParser.appendScope(sb, modifierList[0], false);
        if (ABSTRACT.equals(modifierList[0]) || ABSTRACT.equals(modifierList[1])) {
            sb.append("abstract\\s");
        } else if (!NON_ABSTRACT.equals(modifierList[0]) && !NON_ABSTRACT.equals(modifierList[1])) {
            sb.append("(abstract\\s)?");
        }
        if (STATIC.equals(modifierList[1]) || STATIC.equals(modifierList[2])) {
            sb.append("static\\s");
        } else if (!NON_STATIC.equals(modifierList[1]) && !NON_STATIC.equals(modifierList[2])) {
            sb.append("(static\\s)?");
        }
        if (FINAL.equals(modifierList[2]) || FINAL.equals(modifierList[3])) {
            sb.append("final\\s");
        } else if (!NON_FINAL.equals(modifierList[2]) && !NON_FINAL.equals(modifierList[3])) {
            sb.append("(final\\s)?");
        }
        if (SYNCHRONIZED.equals(modifierList[3]) || SYNCHRONIZED.equals(modifierList[4])) {
            sb.append("synchronized\\s");
        } else if (!NON_SYNCHRONIZED.equals(modifierList[3]) && !NON_SYNCHRONIZED.equals(modifierList[4])) {
            sb.append("(synchronized\\s)?");
        }
        PatternParser.checkNative(sb, modifierList[4]);
    }

    private static void onFourModifiers(String[] modifierList, StringBuilder sb) throws InvalidPatternException {
        PatternParser.appendScope(sb, modifierList[0], false);
        if (ABSTRACT.equals(modifierList[0]) || ABSTRACT.equals(modifierList[1])) {
            sb.append("abstract\\s");
        } else if (!NON_ABSTRACT.equals(modifierList[0]) && !NON_ABSTRACT.equals(modifierList[1])) {
            sb.append("(abstract\\s)?");
        }
        if (STATIC.equals(modifierList[0]) || STATIC.equals(modifierList[1]) || STATIC.equals(modifierList[2])) {
            sb.append("static\\s");
        } else if (!(NON_STATIC.equals(modifierList[0]) || NON_STATIC.equals(modifierList[1]) || NON_STATIC.equals(modifierList[2]))) {
            sb.append("(static\\s)?");
        }
        if (FINAL.equals(modifierList[1]) || FINAL.equals(modifierList[2]) || FINAL.equals(modifierList[3])) {
            sb.append("final\\s");
        } else if (!(NON_FINAL.equals(modifierList[1]) || NON_FINAL.equals(modifierList[2]) || NON_FINAL.equals(modifierList[3]))) {
            sb.append("(final\\s)?");
        }
        if (SYNCHRONIZED.equals(modifierList[2]) || SYNCHRONIZED.equals(modifierList[3])) {
            sb.append("synchronized\\s");
        } else if (!NON_SYNCHRONIZED.equals(modifierList[2]) && !NON_SYNCHRONIZED.equals(modifierList[3])) {
            sb.append("(synchronized\\s)?");
        }
        PatternParser.checkNative(sb, modifierList[3]);
    }

    private static void onThreeModifiers(String[] modifierList, StringBuilder sb) throws InvalidPatternException {
        PatternParser.appendScope(sb, modifierList[0], false);
        if (ABSTRACT.equals(modifierList[0]) || ABSTRACT.equals(modifierList[1])) {
            sb.append("abstract\\s");
        } else if (!NON_ABSTRACT.equals(modifierList[0]) && !NON_ABSTRACT.equals(modifierList[1])) {
            sb.append("(abstract\\s)?");
        }
        if (STATIC.equals(modifierList[0]) || STATIC.equals(modifierList[1]) || STATIC.equals(modifierList[2])) {
            sb.append("static\\s");
        } else if (!(NON_STATIC.equals(modifierList[0]) || NON_STATIC.equals(modifierList[1]) || NON_STATIC.equals(modifierList[2]))) {
            sb.append("(static\\s)?");
        }
        if (FINAL.equals(modifierList[0]) || FINAL.equals(modifierList[1]) || FINAL.equals(modifierList[2])) {
            sb.append("final\\s");
        } else if (!(NON_FINAL.equals(modifierList[0]) || NON_FINAL.equals(modifierList[1]) || NON_FINAL.equals(modifierList[2]))) {
            sb.append("(final\\s)?");
        }
        if (SYNCHRONIZED.equals(modifierList[1]) || SYNCHRONIZED.equals(modifierList[2])) {
            sb.append("synchronized\\s");
        } else if (!NON_SYNCHRONIZED.equals(modifierList[1]) && NON_SYNCHRONIZED.equals(modifierList[2])) {
            sb.append("(synchronized\\s)?");
        }
        PatternParser.checkNative(sb, modifierList[2]);
    }

    private static void onTwoModifiers(String[] modifierList, StringBuilder sb) throws InvalidPatternException {
        PatternParser.appendScope(sb, modifierList[0], false);
        if (ABSTRACT.equals(modifierList[0]) || ABSTRACT.equals(modifierList[1])) {
            sb.append("abstract\\s");
        } else if (!NON_ABSTRACT.equals(modifierList[0]) && !NON_ABSTRACT.equals(modifierList[1])) {
            sb.append("(abstract\\s)?");
        }
        if (STATIC.equals(modifierList[0]) || STATIC.equals(modifierList[1])) {
            sb.append("static\\s");
        } else if (!NON_STATIC.equals(modifierList[0]) && !NON_STATIC.equals(modifierList[1])) {
            sb.append("(static\\s)?");
        }
        if (FINAL.equals(modifierList[0]) || FINAL.equals(modifierList[1])) {
            sb.append("final\\s");
        } else if (!NON_FINAL.equals(modifierList[0]) && !NON_FINAL.equals(modifierList[1])) {
            sb.append("(final\\s)?");
        }
        if (SYNCHRONIZED.equals(modifierList[0]) || SYNCHRONIZED.equals(modifierList[1])) {
            sb.append("synchronized\\s");
        } else if (!NON_SYNCHRONIZED.equals(modifierList[0]) && !NON_SYNCHRONIZED.equals(modifierList[1])) {
            sb.append("(synchronized\\s)?");
        }
        PatternParser.checkNative(sb, modifierList[1]);
    }

    private static void onOneModifier(String[] modifierList, StringBuilder sb) throws InvalidPatternException {
        String[] tokens = new String[]{MODIFIER_PUBLIC, MODIFIER_PRIVATE, MODIFIER_PROTECTED, PACKAGE, ABSTRACT, NON_ABSTRACT, STATIC, NON_STATIC, FINAL, NON_FINAL, SYNCHRONIZED, NON_SYNCHRONIZED, NATIVE, NON_NATIVE};
        String[] outputs = new String[]{"public\\s(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "private\\s(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "protected\\s(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?abstract\\s(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?(static\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?static\\s(final\\s)?(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?(final\\s)?(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?final\\s(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(synchronized\\s)?(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?synchronized\\s(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(native\\s)?", "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?native\\s", "((public|private|protected)\\s)?(abstract\\s)?(static\\s)?(final\\s)?(synchronized\\s)?"};
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals(modifierList[0])) continue;
            sb.append(outputs[i]);
            return;
        }
        throw new InvalidPatternException("Invalid modifier.");
    }

    private static void appendScope(StringBuilder signatureRegex, String scope, boolean fail) throws InvalidPatternException {
        if (MODIFIER_PUBLIC.equals(scope)) {
            signatureRegex.append("public\\s");
        } else if (MODIFIER_PRIVATE.equals(scope)) {
            signatureRegex.append("private\\s");
        } else if (MODIFIER_PROTECTED.equals(scope)) {
            signatureRegex.append("protected\\s");
        } else if (!PACKAGE.equals(scope)) {
            if (fail) {
                throw new InvalidPatternException("Invalid modifier.");
            }
            signatureRegex.append("((public|private|protected)\\s)?");
        }
    }

    private static void checkNative(StringBuilder signatureRegex, String modifier) {
        if (NATIVE.equals(modifier)) {
            signatureRegex.append("native\\s");
        } else if (!NON_NATIVE.equals(modifier)) {
            signatureRegex.append("(native\\s)?");
        }
    }

    private static String parseThrowsPattern(String throwsPattern) throws InvalidPatternException {
        if (null == throwsPattern) {
            return "";
        }
        String trimThrowsPattern = throwsPattern.trim();
        if (!trimThrowsPattern.startsWith("throws")) {
            throw new InvalidPatternException("Invalid throws pattern.");
        }
        String params = trimThrowsPattern.replaceFirst("throws(\\s+)", "");
        String[] paramList = params.split(",");
        if (paramList.length == 1 && "..".equals(paramList[0])) {
            return "(\\sthrows\\s.*)?";
        }
        try {
            return "\\sthrows\\s".concat(PatternParser.parseParameterList(paramList));
        }
        catch (InvalidPatternException ex) {
            throw new InvalidPatternException("Invalid throws pattern.", ex);
        }
    }

    static {
        ALLOWED_MODIFIER_WITH_ORDER.put(MODIFIER_PUBLIC, 0);
        ALLOWED_MODIFIER_WITH_ORDER.put(MODIFIER_PRIVATE, 0);
        ALLOWED_MODIFIER_WITH_ORDER.put(MODIFIER_PROTECTED, 0);
        ALLOWED_MODIFIER_WITH_ORDER.put(PACKAGE, 0);
        ALLOWED_MODIFIER_WITH_ORDER.put(ABSTRACT, 1);
        ALLOWED_MODIFIER_WITH_ORDER.put(NON_ABSTRACT, 1);
        ALLOWED_MODIFIER_WITH_ORDER.put(STATIC, 2);
        ALLOWED_MODIFIER_WITH_ORDER.put(NON_STATIC, 2);
        ALLOWED_MODIFIER_WITH_ORDER.put(FINAL, 3);
        ALLOWED_MODIFIER_WITH_ORDER.put(NON_FINAL, 3);
        ALLOWED_MODIFIER_WITH_ORDER.put(SYNCHRONIZED, 4);
        ALLOWED_MODIFIER_WITH_ORDER.put(NON_SYNCHRONIZED, 4);
        ALLOWED_MODIFIER_WITH_ORDER.put(NATIVE, 5);
        ALLOWED_MODIFIER_WITH_ORDER.put(NON_NATIVE, 5);
    }
}

