/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.signaturePattern;

import kieker.monitoring.core.signaturePattern.InvalidPatternException;

public final class SignatureFactory {
    public static final char PATTERN_PREFIX = '%';
    public static final String COLONS = "::";
    public static final String PATTERN_PREFIX_CPU = "%CPU";
    public static final String PATTERN_PREFIX_MEM_SWAP = "%MEM_SWAP";
    public static final String PATTERN_PREFIX_LOAD_AVERAGE = "%LOAD_AVERAGE";
    public static final String PATTERN_PREFIX_NETWORK_UTILIZATION = "%NETWORK_UTILIZATION";
    public static final String PATTERN_PREFIX_DISK_USAGE = "%DISK_USAGE";
    public static final String PATTERN_PREFIX_JVM_MEM = "%JVM_MEM";
    public static final String PATTERN_PREFIX_JVM_CL = "%JVM_CL";
    public static final String PATTERN_PREFIX_JVM_UP_TIME = "%JVM_UPTIME";
    public static final String PATTERN_PREFIX_JVM_THREADS = "%JVM_THREADS";
    public static final String PATTERN_PREFIX_JVM_COMPILATION = "%JVM_COMPILATION";
    public static final String PATTERN_PREFIX_JVM_GC = "%JVM_GC";

    private SignatureFactory() {
    }

    public static String createCPUSignature(int cpuid) {
        return new StringBuilder(8).append(PATTERN_PREFIX_CPU).append(COLONS).append(cpuid).toString();
    }

    public static String createCPUSignature() {
        return PATTERN_PREFIX_CPU;
    }

    public static String createMemSwapSignature() {
        return PATTERN_PREFIX_MEM_SWAP;
    }

    public static String createLoadAverageSignature() {
        return PATTERN_PREFIX_LOAD_AVERAGE;
    }

    public static String createNetworkUtilizationSignature() {
        return PATTERN_PREFIX_NETWORK_UTILIZATION;
    }

    public static String createDiskUsageSignature() {
        return PATTERN_PREFIX_DISK_USAGE;
    }

    public static String createJVMMemSignature() {
        return PATTERN_PREFIX_JVM_MEM;
    }

    public static String createJVMClassLoadSignature() {
        return PATTERN_PREFIX_JVM_CL;
    }

    public static String createJVMUpTimeSignature() {
        return PATTERN_PREFIX_JVM_UP_TIME;
    }

    public static String createJVMThreadsSignature() {
        return PATTERN_PREFIX_JVM_THREADS;
    }

    public static String createJVMCompilationSignature() {
        return PATTERN_PREFIX_JVM_COMPILATION;
    }

    public static String createJVMGarbageCollectorSignature() {
        return PATTERN_PREFIX_JVM_GC;
    }

    public static String createMethodSignature(String[] modList, String retType, String fqName, String method, String[] params, String[] exceptions) throws InvalidPatternException {
        StringBuilder signature = new StringBuilder(512);
        if (modList != null) {
            for (String element : modList) {
                signature.append(element);
                signature.append(' ');
            }
        }
        if (retType == null) {
            throw new InvalidPatternException("return type is requiered");
        }
        signature.append(retType);
        signature.append(' ');
        if (fqName == null) {
            throw new InvalidPatternException("fully qualified name is requiered");
        }
        signature.append(fqName);
        signature.append('.');
        if (method == null) {
            throw new InvalidPatternException("method name is requiered");
        }
        signature.append(method);
        signature.append('(');
        if (params != null && params.length > 0) {
            signature.append(params[0]);
            for (int i = 1; i < params.length; ++i) {
                signature.append(',');
                signature.append(params[i]);
            }
        }
        signature.append(')');
        if (exceptions != null && exceptions.length > 0) {
            signature.append(" throws ");
            signature.append(exceptions[0]);
            for (int i = 1; i < exceptions.length; ++i) {
                signature.append(',');
                signature.append(exceptions[i]);
            }
        }
        return signature.toString();
    }
}

