/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.beforeafter.onlycallee;

import kieker.common.record.flow.thread.AfterFailedThreadBasedEvent;
import kieker.common.record.flow.thread.AfterThreadBasedEvent;
import kieker.common.record.flow.thread.BeforeThreadBasedEvent;
import kieker.common.record.misc.ThreadMetaData;
import kieker.monitoring.IdGenerator;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.probe.aspectj.beforeafter.onlycallee.Counter;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractAspectWithoutTraceRegistry
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private final IdGenerator idGenerator = new IdGenerator();
    private final ThreadLocal<Long> threadLocalId = new ThreadLocal();
    private final ThreadLocal<Counter> currentOrderIndex = new ThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };

    @Pointcut
    public abstract void monitoredOperation();

    @Before(value="monitoredOperation() && notWithinKieker()")
    public void beforeOperation(JoinPoint.StaticPart jpStaticPart) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        Long threadId = this.threadLocalId.get();
        if (null == threadId) {
            threadId = this.idGenerator.getNewId();
            this.threadLocalId.set(threadId);
            CTRLINST.newMonitoringRecord(new ThreadMetaData(CTRLINST.getHostname(), threadId));
        }
        int orderIndex = this.currentOrderIndex.get().incrementValue();
        String typeName = jpStaticPart.getSignature().getDeclaringTypeName();
        CTRLINST.newMonitoringRecord(new BeforeThreadBasedEvent(TIME.getTime(), threadId, orderIndex, operationSignature, typeName));
    }

    @AfterReturning(value="monitoredOperation() && notWithinKieker()")
    public void afterReturningOperation(JoinPoint.StaticPart jpStaticPart) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        long threadId = this.threadLocalId.get();
        int orderIndex = this.currentOrderIndex.get().incrementValue();
        String typeName = jpStaticPart.getSignature().getDeclaringTypeName();
        CTRLINST.newMonitoringRecord(new AfterThreadBasedEvent(TIME.getTime(), threadId, orderIndex, operationSignature, typeName));
    }

    @AfterThrowing(pointcut="monitoredOperation() && notWithinKieker()", throwing="th")
    public void afterThrowing(JoinPoint.StaticPart jpStaticPart, Throwable th) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(jpStaticPart.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        long threadId = this.threadLocalId.get();
        int orderIndex = this.currentOrderIndex.get().incrementValue();
        String typeName = jpStaticPart.getSignature().getDeclaringTypeName();
        CTRLINST.newMonitoringRecord(new AfterFailedThreadBasedEvent(TIME.getTime(), threadId, orderIndex, operationSignature, typeName, th.toString()));
    }
}

