/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.cxf;

import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.probe.cxf.OperationExecutionSOAPResponseOutInterceptor;
import kieker.monitoring.probe.cxf.SOAPHeaderConstants;
import kieker.monitoring.probe.cxf.SOAPTraceRegistry;
import kieker.monitoring.timer.ITimeSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperationExecutionSOAPRequestInInterceptor
extends SoapHeaderInterceptor
implements IMonitoringProbe {
    public static final String SESSION_ID_ASYNC_TRACE = "NOSESSION-ASYNCIN";
    protected static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    protected static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    protected static final SOAPTraceRegistry SOAP_REGISTRY = SOAPTraceRegistry.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutionSOAPRequestInInterceptor.class);
    protected final IMonitoringController monitoringController;
    protected final ITimeSource timeSource;

    public OperationExecutionSOAPRequestInInterceptor() {
        this(MonitoringController.getInstance());
    }

    public OperationExecutionSOAPRequestInInterceptor(IMonitoringController monitoringCtrl) {
        this.monitoringController = monitoringCtrl;
        this.timeSource = this.monitoringController.getTimeSource();
    }

    public void handleMessage(Message msg) throws Fault {
        if (!this.monitoringController.isMonitoringEnabled()) {
            return;
        }
        if (!this.monitoringController.isProbeActivated(OperationExecutionSOAPResponseOutInterceptor.SIGNATURE)) {
            return;
        }
        if (msg instanceof SoapMessage) {
            SoapMessage soapMsg = (SoapMessage)msg;
            long tin = this.timeSource.getTime();
            boolean isEntryCall = false;
            Header hdr = soapMsg.getHeader(SOAPHeaderConstants.SESSION_IDENTIFIER_QNAME);
            String sessionId = this.getStringContentFromHeader(hdr);
            if (sessionId == null) {
                sessionId = "<no-session-id>";
            }
            hdr = soapMsg.getHeader(SOAPHeaderConstants.EOI_IDENTIFIER_QNAME);
            String eoiStr = this.getStringContentFromHeader(hdr);
            int eoi = -1;
            if (eoiStr != null) {
                try {
                    eoi = 1 + Integer.parseInt(eoiStr);
                }
                catch (NumberFormatException exc) {
                    LOGGER.warn("Invalid eoi", (Throwable)exc);
                }
            }
            hdr = soapMsg.getHeader(SOAPHeaderConstants.ESS_IDENTIFIER_QNAME);
            String essStr = this.getStringContentFromHeader(hdr);
            int ess = -1;
            if (essStr != null) {
                try {
                    ess = Integer.parseInt(essStr);
                }
                catch (NumberFormatException exc) {
                    LOGGER.warn("Invalid ess", (Throwable)exc);
                }
            }
            hdr = soapMsg.getHeader(SOAPHeaderConstants.TRACE_IDENTIFIER_QNAME);
            String traceIdStr = this.getStringContentFromHeader(hdr);
            long traceId = -1L;
            if (traceIdStr != null) {
                try {
                    traceId = Long.parseLong(traceIdStr);
                }
                catch (NumberFormatException exc) {
                    LOGGER.warn("Invalid trace id", (Throwable)exc);
                }
            } else {
                traceId = CF_REGISTRY.getUniqueTraceId();
                sessionId = SESSION_ID_ASYNC_TRACE;
                isEntryCall = true;
                eoi = 0;
                ess = 0;
            }
            CF_REGISTRY.storeThreadLocalTraceId(traceId);
            CF_REGISTRY.storeThreadLocalEOI(eoi);
            CF_REGISTRY.storeThreadLocalESS(ess + 1);
            SESSION_REGISTRY.storeThreadLocalSessionId(sessionId);
            SOAP_REGISTRY.storeThreadLocalInRequestIsEntryCall(isEntryCall);
            SOAP_REGISTRY.storeThreadLocalInRequestTin(tin);
            SOAP_REGISTRY.storeThreadLocalInRequestEOI(eoi);
            SOAP_REGISTRY.storeThreadLocalInRequestESS(ess);
        }
    }

    private final String getStringContentFromHeader(Header hdr) {
        if (hdr == null) {
            return null;
        }
        if (hdr.getObject() instanceof Element) {
            Element e = (Element)hdr.getObject();
            return DOMUtils.getContent((Node)e);
        }
        return null;
    }
}

