/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.signature.ClassOperationSignaturePair;
import kieker.common.util.signature.Signature;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAndTraceRegistrationFilter
implements Filter,
IMonitoringProbe {
    public static final String CONFIG_PROPERTY_NAME_LOG_FILTER_EXECUTION = "logFilterExecution";
    protected static final IMonitoringController MONITORING_CTRL = MonitoringController.getInstance();
    protected static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    protected static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    protected static final ITimeSource TIMESOURCE = MONITORING_CTRL.getTimeSource();
    protected static final String VM_NAME = MONITORING_CTRL.getHostname();
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionAndTraceRegistrationFilter.class);
    private final String filterOperationSignatureString;
    private volatile boolean logFilterExecution = true;

    public SessionAndTraceRegistrationFilter() {
        Signature methodSignature = new Signature("doFilter", new String[]{"public"}, "void", new String[]{ServletRequest.class.getName(), ServletResponse.class.getName(), FilterChain.class.getName()});
        ClassOperationSignaturePair filterOperationSignaturePair = new ClassOperationSignaturePair(SessionAndTraceRegistrationFilter.class.getName(), methodSignature);
        this.filterOperationSignatureString = filterOperationSignaturePair.toString();
    }

    public SessionAndTraceRegistrationFilter(boolean logFilterExecution) {
        this();
        this.logFilterExecution = logFilterExecution;
    }

    protected String getFilterOperationSignatureString() {
        return this.filterOperationSignatureString;
    }

    public void init(FilterConfig config) throws ServletException {
        String valString = config.getInitParameter(CONFIG_PROPERTY_NAME_LOG_FILTER_EXECUTION);
        if (valString != null) {
            this.logFilterExecution = Boolean.parseBoolean(valString);
        } else {
            LOGGER.warn("Filter configuration '{}' not set. Using the value: {}", (Object)CONFIG_PROPERTY_NAME_LOG_FILTER_EXECUTION, (Object)this.logFilterExecution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!MONITORING_CTRL.isMonitoringEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        if (!MONITORING_CTRL.isProbeActivated(this.filterOperationSignatureString)) {
            chain.doFilter(request, response);
            return;
        }
        String sessionId = this.registerSessionInformation(request);
        long traceId = -1L;
        if (this.logFilterExecution) {
            traceId = CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
            CF_REGISTRY.storeThreadLocalEOI(0);
            CF_REGISTRY.storeThreadLocalESS(1);
        }
        long tin = TIMESOURCE.getTime();
        try {
            chain.doFilter(request, response);
        }
        finally {
            SESSION_REGISTRY.unsetThreadLocalSessionId();
            if (this.logFilterExecution) {
                long tout = TIMESOURCE.getTime();
                if (sessionId == "<no-session-id>") {
                    sessionId = this.registerSessionInformation(request);
                }
                MONITORING_CTRL.newMonitoringRecord(new OperationExecutionRecord(this.getFilterOperationSignatureString(), sessionId, traceId, tin, tout, VM_NAME, 0, 0));
                CF_REGISTRY.unsetThreadLocalTraceId();
                CF_REGISTRY.unsetThreadLocalEOI();
                CF_REGISTRY.unsetThreadLocalESS();
            }
        }
    }

    public void destroy() {
    }

    protected String registerSessionInformation(ServletRequest request) {
        String sessionId = "<no-session-id>";
        if (request == null || !(request instanceof HttpServletRequest)) {
            return sessionId;
        }
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        if (session != null) {
            sessionId = session.getId();
            SESSION_REGISTRY.storeThreadLocalSessionId(sessionId);
        }
        return sessionId;
    }
}

