/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import kieker.common.record.system.CPUUtilizationRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.oshi.samplers.AbstractOshiSampler;
import kieker.monitoring.sampler.oshi.samplers.CPUsDetailedPercConverter;
import kieker.monitoring.timer.ITimeSource;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public final class CPUsDetailedPercSampler
extends AbstractOshiSampler {
    private CPUsDetailedPercConverter[] converters;

    public CPUsDetailedPercSampler(HardwareAbstractionLayer hardwareAbstractionLayer) {
        super(hardwareAbstractionLayer);
    }

    @Override
    public void sample(IMonitoringController monitoringController) {
        if (!monitoringController.isMonitoringEnabled() || !monitoringController.isProbeActivated(SignatureFactory.createCPUSignature())) {
            return;
        }
        CentralProcessor centralProcessor = this.hardwareAbstractionLayer.getProcessor();
        long[][] processorLoadTicks = centralProcessor.getProcessorCpuLoadTicks();
        if (this.converters == null) {
            this.converters = new CPUsDetailedPercConverter[processorLoadTicks.length];
            for (int i = 0; i < this.converters.length; ++i) {
                this.converters[i] = new CPUsDetailedPercConverter(i);
            }
        }
        ITimeSource timesource = monitoringController.getTimeSource();
        for (int i = 0; i < processorLoadTicks.length; ++i) {
            if (!monitoringController.isProbeActivated(SignatureFactory.createCPUSignature(i))) continue;
            CPUsDetailedPercConverter converter = this.converters[i];
            long[] plt = processorLoadTicks[i];
            converter.passNewProcessorLoadTicks(plt);
            converter.convertToPercentage();
            double system = converter.getSystemPerc();
            double wait = converter.getWaitPerc();
            double nice = converter.getNicePerc();
            double idle = converter.getIdlePerc();
            double user = converter.getUserPerc();
            double irq = converter.getIrqPerc();
            double combined = centralProcessor.getProcessorCpuLoadBetweenTicks()[i];
            CPUUtilizationRecord r = new CPUUtilizationRecord(timesource.getTime(), monitoringController.getHostname(), Integer.toString(i), user, system, wait, nice, irq, combined, idle);
            monitoringController.newMonitoringRecord(r);
        }
    }
}

