/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.concurrent.BlockingQueue;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringWriterThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringWriterThread.class);
    private static final IMonitoringRecord END_OF_MONITORING_RECORD = new EmptyRecord();
    private final BlockingQueue<IMonitoringRecord> writerQueue;
    private final AbstractMonitoringWriter writer;

    public MonitoringWriterThread(AbstractMonitoringWriter writer, BlockingQueue<IMonitoringRecord> writerQueue) {
        if (writer == null) {
            throw new NullPointerException("The given writer may not be null.");
        }
        if (writerQueue == null) {
            throw new NullPointerException("The given writerQueue may not be null.");
        }
        this.writer = writer;
        this.writerQueue = writerQueue;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        LOGGER.debug("{} is running.", (Object)this.getClass().getName());
        this.writer.onStarting();
        try {
            IMonitoringRecord record = this.writerQueue.take();
            while (record != END_OF_MONITORING_RECORD) {
                this.writer.writeMonitoringRecord(record);
                record = this.writerQueue.take();
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("{} was interrupted.", (Object)this.getClass().getName(), (Object)e);
        }
        this.writer.onTerminating();
        LOGGER.debug("{} has finished.", (Object)this.getClass().getName());
    }

    public void terminate() {
        try {
            this.writerQueue.put(END_OF_MONITORING_RECORD);
        }
        catch (InterruptedException e) {
            LOGGER.warn("An exception occurred", (Throwable)e);
        }
    }
}

