/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;

public final class WriterUtil {
    private WriterUtil() {
    }

    public static long flushBuffer(ByteBuffer buffer, WritableByteChannel writableChannel, Logger logger) {
        long bytesWritten = 0L;
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                bytesWritten += (long)writableChannel.write(buffer);
            }
            buffer.clear();
        }
        catch (IOException e) {
            logger.error("Caught exception while writing to the channel.", (Throwable)e);
            WriterUtil.close(writableChannel, logger);
        }
        return bytesWritten;
    }

    public static void close(Closeable closeable, Logger logger) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.warn("Caught exception while closing '{}'.", closeable.getClass(), (Object)e);
        }
    }
}

