/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kieker.monitoring.writer.filesystem.ILogFilePoolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotatingLogFilePoolHandler
implements ILogFilePoolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RotatingLogFilePoolHandler.class);
    private static final String TIME_ZONE = "UTC";
    private static final Locale LOCALE = Locale.US;
    private final List<Path> logFiles = new ArrayList<Path>();
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", LOCALE);
    private final Path location;
    private int counter;
    private final String fileExtensionWithDot;
    private final int maxAmountOfFiles;

    public RotatingLogFilePoolHandler(Path location, String extension, Integer maxAmountOfFiles) {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        this.maxAmountOfFiles = maxAmountOfFiles;
        this.location = location;
        this.fileExtensionWithDot = extension;
    }

    @Override
    public Path requestFile() {
        ++this.counter;
        if (this.counter > this.maxAmountOfFiles) {
            Path oldestFile = this.logFiles.remove(0);
            try {
                Files.delete(oldestFile);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete oldest file.", (Throwable)e);
            }
        }
        Date now = new Date();
        String fileName = String.format(LOCALE, "%s-%s-%s-%03d%s", "kieker", this.dateFormatter.format(now), TIME_ZONE, this.counter, this.fileExtensionWithDot);
        Path logFile = this.location.resolve(fileName);
        this.logFiles.add(logFile);
        return logFile;
    }
}

