/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.jmx.KiekerJmxMonitoringLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxWriter
extends AbstractMonitoringWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxWriter.class);
    private static final String PREFIX = JmxWriter.class.getName() + ".";
    public static final String CONFIG_DOMAIN = PREFIX + "domain";
    public static final String CONFIG_LOGNAME = PREFIX + "logname";
    private final String configDomain;
    private final String configLogname;
    private KiekerJmxMonitoringLog kiekerJmxMonitoringLog;
    private ObjectName monitoringLogName;

    public JmxWriter(Configuration configuration) {
        super(configuration);
        this.configDomain = configuration.getStringProperty(CONFIG_DOMAIN);
        this.configLogname = configuration.getStringProperty(CONFIG_LOGNAME);
    }

    @Override
    public void onStarting() {
        try {
            String domain = this.configDomain;
            if ("".equals(domain)) {
                domain = MonitoringController.getInstance().getControllerDomain();
            }
            this.monitoringLogName = new ObjectName(domain, "type", this.configLogname);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException("The generated ObjectName is not correct! Check the following configuration values '" + CONFIG_DOMAIN + "=" + this.configDomain + "' and '" + CONFIG_LOGNAME + "=" + this.configLogname + "'", ex);
        }
        this.kiekerJmxMonitoringLog = new KiekerJmxMonitoringLog(this.monitoringLogName);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.kiekerJmxMonitoringLog, this.monitoringLogName);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to inititialize JmxWriter.", ex);
        }
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        this.kiekerJmxMonitoringLog.newMonitoringRecord(record);
    }

    @Override
    public void onTerminating() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.monitoringLogName);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to terminate writer", (Throwable)ex);
        }
    }
}

