/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.executionRecordTransformation;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.signature.ClassOperationSignaturePair;
import kieker.tools.trace.analysis.filter.AbstractTraceAnalysisFilter;
import kieker.tools.trace.analysis.systemModel.Execution;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Deprecated
@Plugin(description="A filter transforming OperationExecutionRecords into Execution objects", outputPorts={@OutputPort(name="transformedExecutions", description="Provides transformed executions", eventTypes={Execution.class})}, repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public class ExecutionRecordTransformationFilter
extends AbstractTraceAnalysisFilter {
    public static final String INPUT_PORT_NAME_RECORDS = "operationExecutionRecords";
    public static final String OUTPUT_PORT_NAME_EXECUTIONS = "transformedExecutions";

    public ExecutionRecordTransformationFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @InputPort(name="operationExecutionRecords", description="Receives operation execution records to be transformed", eventTypes={OperationExecutionRecord.class})
    public void inputOperationExecutionRecords(OperationExecutionRecord operationExecutionRecord) {
        String operationSignature = operationExecutionRecord.getOperationSignature();
        boolean isConstructor = operationSignature.contains("<init>");
        ClassOperationSignaturePair fqComponentNameSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr(operationExecutionRecord.getOperationSignature(), isConstructor);
        Execution execution = this.createExecutionByEntityNames(operationExecutionRecord.getHostname(), fqComponentNameSignaturePair.getFqClassname(), fqComponentNameSignaturePair.getSignature(), operationExecutionRecord.getTraceId(), operationExecutionRecord.getSessionId(), operationExecutionRecord.getEoi(), operationExecutionRecord.getEss(), operationExecutionRecord.getTin(), operationExecutionRecord.getTout(), false);
        super.deliver(OUTPUT_PORT_NAME_EXECUTIONS, execution);
    }
}

