/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.tools.trace.analysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.exception.GraphFormattingException;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.visualization.trace.dependency.graph.ComponentAllocationDependencyGraph;
import kieker.visualization.trace.dependency.graph.ComponentAllocationDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.ComponentAssemblyDependencyGraph;
import kieker.visualization.trace.dependency.graph.ComponentAssemblyDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.ContainerDependencyGraph;
import kieker.visualization.trace.dependency.graph.ContainerDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.OperationAllocationDependencyGraph;
import kieker.visualization.trace.dependency.graph.OperationAllocationDependencyGraphFormatter;
import kieker.visualization.trace.dependency.graph.OperationAssemblyDependencyGraph;
import kieker.visualization.trace.dependency.graph.OperationAssemblyDependencyGraphFormatter;
import teetime.framework.AbstractConsumerStage;

public class GraphWriterPlugin
extends AbstractConsumerStage<AbstractGraph<?, ?, ?>> {
    private static final String NO_SUITABLE_FORMATTER_MESSAGE_TEMPLATE = "No formatter type defined for graph type %s.";
    private static final String INSTANTIATION_ERROR_MESSAGE_TEMPLATE = "Could not instantiate formatter type %s for graph type %s.";
    private static final String WRITE_ERROR_MESSAGE_TEMPLATE = "Graph could not be written to file %s.";
    private static final ConcurrentMap<Class<? extends AbstractGraph<?, ?, ?>>, Class<? extends AbstractGraphFormatter<?>>> FORMATTER_REGISTRY = new ConcurrentHashMap();
    private final String outputPathName;
    private final String outputFileName;
    private final boolean includeWeights;
    private final boolean useShortLabels;
    private final boolean plotLoops;

    public GraphWriterPlugin(String outputPathName, String outputFileName, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        this.outputPathName = outputPathName;
        this.outputFileName = outputFileName;
        this.includeWeights = includeWeights;
        this.useShortLabels = useShortLabels;
        this.plotLoops = plotLoops;
    }

    private static void handleInstantiationException(Class<?> graphClass, Class<?> formatterClass, Exception exception) {
        throw new GraphFormattingException(String.format(INSTANTIATION_ERROR_MESSAGE_TEMPLATE, formatterClass.getName(), graphClass.getName()), exception);
    }

    private static AbstractGraphFormatter<?> createFormatter(AbstractGraph<?, ?, ?> graph) {
        Class formatterClass = (Class)FORMATTER_REGISTRY.get(graph.getClass());
        if (formatterClass == null) {
            throw new GraphFormattingException(String.format(NO_SUITABLE_FORMATTER_MESSAGE_TEMPLATE, graph.getClass().getName()));
        }
        try {
            Constructor constructor = formatterClass.getConstructor(new Class[0]);
            return (AbstractGraphFormatter)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            GraphWriterPlugin.handleInstantiationException(graph.getClass(), formatterClass, e);
            return null;
        }
    }

    private String getOutputFileName(AbstractGraphFormatter<?> formatter) {
        if (this.outputFileName.length() == 0) {
            return formatter.getDefaultFileName();
        }
        return this.outputFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(AbstractGraph<?, ?, ?> graph) throws Exception {
        AbstractGraphFormatter<?> graphFormatter = GraphWriterPlugin.createFormatter(graph);
        String specification = graphFormatter.createFormattedRepresentation(graph, this.includeWeights, this.useShortLabels, this.plotLoops);
        String fileName = this.outputPathName + File.separator + this.getOutputFileName(graphFormatter);
        BufferedWriter writer = null;
        try {
            writer = Files.newBufferedWriter(Paths.get(fileName, new String[0]), new OpenOption[0]);
            writer.write(specification);
            writer.flush();
            if (writer == null) return;
        }
        catch (IOException e) {
            try {
                throw new GraphFormattingException(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, fileName), e);
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (!this.logger.isErrorEnabled()) throw throwable;
                    this.logger.error(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, fileName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            writer.close();
            return;
        }
        catch (IOException e) {
            if (!this.logger.isErrorEnabled()) return;
            this.logger.error(String.format(WRITE_ERROR_MESSAGE_TEMPLATE, fileName), (Throwable)e);
            return;
        }
    }

    static {
        FORMATTER_REGISTRY.put(ComponentAllocationDependencyGraph.class, ComponentAllocationDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(ComponentAssemblyDependencyGraph.class, ComponentAssemblyDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(OperationAllocationDependencyGraph.class, OperationAllocationDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(OperationAssemblyDependencyGraph.class, OperationAssemblyDependencyGraphFormatter.class);
        FORMATTER_REGISTRY.put(ContainerDependencyGraph.class, ContainerDependencyGraphFormatter.class);
    }
}

