/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace;

import java.util.HashSet;
import java.util.Map;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.model.system.model.TraceInformation;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractEdge;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractVertex;
import kieker.tools.trace.analysis.filter.visualization.graph.Color;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.SpecificOriginRetentionPolicy;
import kieker.tools.trace.analysis.repository.TraceColorRepository;
import kieker.visualization.trace.AbstractGraphFilter;

public class TraceColoringFilter<V extends AbstractVertex<V, E, TraceInformation>, E extends AbstractEdge<V, E, TraceInformation>>
extends AbstractGraphFilter<AbstractGraph<V, E, TraceInformation>, V, E, TraceInformation>
implements AbstractGraph.IGraphVisitor<V, E> {
    private final Map<Long, Color> colorMap;
    private final Color defaultColor;
    private final Color collisionColor;

    public TraceColoringFilter(TraceColorRepository colorRepository) {
        this.colorMap = colorRepository.getColorMap();
        this.defaultColor = colorRepository.getDefaultColor();
        this.collisionColor = colorRepository.getCollisionColor();
    }

    private void handleGraphElement(AbstractGraphElement<TraceInformation> element) {
        TraceInformation relevantTraceInformation = null;
        int relevantOrigins = 0;
        for (TraceInformation traceInformation : element.getOrigins()) {
            long traceId = traceInformation.getTraceId();
            if (!this.colorMap.containsKey(traceId)) continue;
            relevantTraceInformation = traceInformation;
            ++relevantOrigins;
        }
        if (relevantOrigins == 0) {
            element.setColor(this.defaultColor);
        } else if (relevantOrigins > 1) {
            element.setColor(this.collisionColor);
        } else {
            long traceId = relevantTraceInformation.getTraceId();
            Color color = this.colorMap.get(traceId);
            element.setColor(color);
        }
    }

    @Override
    public void visitVertex(V vertex) {
        this.handleGraphElement((AbstractGraphElement<TraceInformation>)vertex);
    }

    @Override
    public void visitEdge(E edge) {
        this.handleGraphElement((AbstractGraphElement<TraceInformation>)edge);
    }

    @Override
    protected AbstractGraph<V, E, TraceInformation> performConcreteGraphProcessing(AbstractGraph<V, E, TraceInformation> graph) {
        graph.traverse(this);
        return graph;
    }

    @Override
    protected IOriginRetentionPolicy getDesiredOriginRetentionPolicy() throws AnalysisConfigurationException {
        HashSet<TraceInformation> desiredTraces = new HashSet<TraceInformation>();
        for (Long traceId : this.colorMap.keySet()) {
            desiredTraces.add(new TraceInformation(traceId, null));
        }
        return SpecificOriginRetentionPolicy.createInstance(desiredTraces);
    }
}

