/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.ISystemModelElement;
import kieker.visualization.trace.AbstractGraphProducingFilter;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraph;
import kieker.visualization.trace.dependency.graph.AbstractNodeDecorator;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public abstract class AbstractDependencyGraphFilter<T extends ISystemModelElement>
extends AbstractGraphProducingFilter<AbstractDependencyGraph<T>> {
    private final List<AbstractNodeDecorator> decorators = new ArrayList<AbstractNodeDecorator>();
    private final TimeUnit timeUnit;

    public AbstractDependencyGraphFilter(SystemModelRepository repository, TimeUnit timeUnit, AbstractDependencyGraph<T> graph) {
        super(repository, graph);
        this.timeUnit = timeUnit;
    }

    public void addDecorator(AbstractNodeDecorator decorator) {
        this.decorators.add(decorator);
    }

    protected void invokeDecorators(AbstractMessage message, DependencyGraphNode<?> sourceNode, DependencyGraphNode<?> targetNode) {
        for (AbstractNodeDecorator currentDecorator : this.decorators) {
            currentDecorator.processMessage(message, sourceNode, targetNode, this.timeUnit);
        }
    }

    protected boolean isDependencyAssumed(DependencyGraphNode<?> source, DependencyGraphNode<?> target) {
        return source.isAssumed() || target.isAssumed();
    }
}

