/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.configuration;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends Properties {
    private static final long serialVersionUID = 3364877592243422259L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);

    public Configuration() {
        this((Properties)null);
    }

    public Configuration(Properties defaults) {
        super(defaults);
    }

    public final String getStringProperty(String key) {
        return this.getStringProperty(key, "");
    }

    public final String getStringProperty(String key, String defaultValue) {
        String s = super.getProperty(key);
        return s == null ? defaultValue : s.trim();
    }

    public final boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getStringProperty(key));
    }

    public final boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getPropertyValueInternal(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.getStringProperty(key));
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, String.valueOf(value));
    }

    public final int getIntProperty(String key) {
        return this.getIntProperty(key, 0);
    }

    public final int getIntProperty(String key, int defaultValue) {
        String value = this.getPropertyValueInternal(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Error parsing configuration property '{}' of type int, found value '{}', using default value {}", key, value, defaultValue);
            return defaultValue;
        }
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public final long getLongProperty(String key) {
        return this.getLongProperty(key, 0L);
    }

    public final long getLongProperty(String key, long defaultValue) {
        String value = this.getPropertyValueInternal(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Error parsing configuration property '{}' of type long, found value '{}', using default value {}", key, value, defaultValue);
            return defaultValue;
        }
    }

    private String getPropertyValueInternal(String key) {
        return super.getProperty(key);
    }

    public void setProperty(String key, long value) {
        this.setProperty(key, String.valueOf(value));
    }

    public final double getDoubleProperty(String key) {
        return this.getDoubleProperty(key, 0.0);
    }

    public final double getDoubleProperty(String key, double defaultValue) {
        String value = this.getPropertyValueInternal(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Error parsing configuration property '{}' of type double, found value '{}', using default value {}", key, value, defaultValue);
            return defaultValue;
        }
    }

    public final <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumType, T defaultValue) {
        Enum[] results;
        String propertyValue = this.getPropertyValueInternal(key);
        if (propertyValue == null) {
            return defaultValue;
        }
        for (Enum value : results = (Enum[])enumType.getEnumConstants()) {
            if (!value.name().equalsIgnoreCase(propertyValue)) continue;
            return (T)value;
        }
        LOGGER.warn("Error parsing configuration property '{}' of type {}, found value '{}', using default value {}", key, enumType.getSimpleName(), propertyValue, defaultValue);
        return defaultValue;
    }

    public void setProperty(String key, double value) {
        this.setProperty(key, String.valueOf(value));
    }

    public final String getPathProperty(String key) {
        return Configuration.convertToPath(this.getStringProperty(key));
    }

    public final String[] getStringArrayProperty(String key) {
        return this.getStringArrayProperty(key, "\\|");
    }

    public void setStringArrayProperty(String key, String[] value) {
        this.setProperty(key, Configuration.toProperty(value));
    }

    public final String[] getStringArrayProperty(String key, String split) {
        String s = this.getStringProperty(key);
        if (s.length() == 0) {
            return new String[0];
        }
        return s.split(split);
    }

    public static final String toProperty(Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    public static final String convertToPath(String pathname) {
        if (pathname.length() == 0) {
            return pathname;
        }
        String workingPathname = pathname.replace('\\', '/');
        boolean endsWithSlash = workingPathname.charAt(workingPathname.length() - 1) == '/';
        List<String> path = Configuration.generatePath(workingPathname);
        StringBuilder sb = new StringBuilder();
        if (workingPathname.charAt(0) == '/') {
            sb.append('/');
        }
        int numberPathElements = path.size();
        Iterator<String> pathIter = path.iterator();
        for (int i = 0; i < numberPathElements - 1; ++i) {
            sb.append(pathIter.next()).append('/');
        }
        if (pathIter.hasNext()) {
            sb.append(pathIter.next());
        }
        if (endsWithSlash && sb.length() != 0 && (sb.length() != 1 || sb.charAt(0) != '/')) {
            sb.append('/');
        }
        String result = sb.toString();
        while (result.startsWith("/../")) {
            result = result.substring(3);
        }
        if ("/..".equals(result)) {
            result = "/";
        }
        return result;
    }

    private static List<String> generatePath(String workingPathname) {
        String[] components = workingPathname.split("/");
        LinkedList<String> path = new LinkedList<String>();
        for (String component : components) {
            if (".".equals(component) || "".equals(component)) continue;
            if ("..".equals(component)) {
                if (!path.isEmpty() && !"..".equals(path.getLast())) {
                    path.removeLast();
                    continue;
                }
                path.add("..");
                continue;
            }
            path.add(component);
        }
        return path;
    }

    public final Configuration getPropertiesStartingWith(String prefix) {
        Configuration configuration = new Configuration(null);
        Set<String> keys = this.stringPropertyNames();
        for (String property : keys) {
            if (!property.startsWith(prefix)) continue;
            configuration.setProperty(property, super.getProperty(property));
        }
        return configuration;
    }

    public final Configuration flatten(Configuration defaultConfiguration) {
        Configuration configuration = new Configuration(defaultConfiguration);
        Set<String> keys = this.stringPropertyNames();
        for (String property : keys) {
            configuration.setProperty(property, super.getProperty(property));
        }
        return configuration;
    }

    public final Configuration flatten() {
        return this.flatten(null);
    }

    public final void flattenInPlace() {
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String property = (String)keys.nextElement();
            this.setProperty(property, super.getProperty(property));
        }
        this.defaults = null;
    }

    public void setDefaultConfiguration(Configuration defaultConfiguration) {
        Configuration conf = this;
        while (conf.defaults != null && conf.defaults instanceof Configuration) {
            conf = (Configuration)conf.defaults;
        }
        if (conf.defaults == null) {
            conf.defaults = defaultConfiguration;
        } else if (defaultConfiguration != null) {
            this.flattenInPlace();
            this.defaults = defaultConfiguration;
        }
    }

    @Override
    @Deprecated
    public final synchronized Object put(Object key, Object value) {
        return super.put(key, value);
    }

    @Override
    @Deprecated
    public final synchronized Object get(Object key) {
        return super.get(key);
    }

    @Override
    @Deprecated
    public final String getProperty(String key) {
        return super.getProperty(key);
    }

    @Override
    @Deprecated
    public final String getProperty(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }
}

