/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.database;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.flow.IClassSignature;
import kieker.common.record.flow.IEventRecord;
import kieker.common.record.flow.IExceptionRecord;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class DatabaseFailedEvent
extends AbstractMonitoringRecord
implements IEventRecord,
IFlowRecord,
IClassSignature,
ITraceRecord,
IExceptionRecord {
    public static final int SIZE = 28;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, Long.TYPE, Integer.TYPE, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "classSignature", "traceId", "orderIndex", "cause"};
    public static final long TIMESTAMP = 0L;
    public static final String CLASS_SIGNATURE = "";
    public static final long TRACE_ID = -1L;
    public static final int ORDER_INDEX = -1;
    public static final String CAUSE = "";
    private static final long serialVersionUID = 979011205753098958L;
    private long timestamp;
    private final String classSignature;
    private long traceId;
    private final int orderIndex;
    private final String cause;

    public DatabaseFailedEvent(long timestamp, String classSignature, long traceId, int orderIndex, String cause) {
        this.timestamp = timestamp;
        this.classSignature = classSignature == null ? "" : classSignature;
        this.traceId = traceId;
        this.orderIndex = orderIndex;
        this.cause = cause == null ? "" : cause;
    }

    public DatabaseFailedEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.classSignature = deserializer.getString();
        this.traceId = deserializer.getLong();
        this.orderIndex = deserializer.getInt();
        this.cause = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getClassSignature());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getCause());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DatabaseFailedEvent castedRecord = (DatabaseFailedEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getClassSignature().equals(castedRecord.getClassSignature()) || this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        return this.getCause().equals(castedRecord.getCause());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getClassSignature().hashCode();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        return code += this.getCause().hashCode();
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }

    @Override
    public final long getTraceId() {
        return this.traceId;
    }

    @Override
    public final void setTraceId(long traceId) {
        this.traceId = traceId;
    }

    @Override
    public final int getOrderIndex() {
        return this.orderIndex;
    }

    @Override
    public final String getCause() {
        return this.cause;
    }

    @Override
    public String toString() {
        Object result = "DatabaseFailedEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "cause = ";
        result = (String)result + this.getCause() + ", ";
        return result;
    }
}

