/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IOperationRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.io.IValueDeserializer;

public abstract class AbstractOperationEvent
extends AbstractTraceEvent
implements IOperationRecord {
    public static final String OPERATION_SIGNATURE = "";
    public static final String CLASS_SIGNATURE = "";
    private static final long serialVersionUID = -34090223642783143L;
    private final String operationSignature;
    private final String classSignature;

    public AbstractOperationEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature) {
        super(timestamp, traceId, orderIndex);
        this.operationSignature = operationSignature == null ? "" : operationSignature;
        this.classSignature = classSignature == null ? "" : classSignature;
    }

    public AbstractOperationEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.operationSignature = deserializer.getString();
        this.classSignature = deserializer.getString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractOperationEvent castedRecord = (AbstractOperationEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        return this.getClassSignature().equals(castedRecord.getClassSignature());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        return code += this.getClassSignature().hashCode();
    }

    @Override
    public final String getOperationSignature() {
        return this.operationSignature;
    }

    @Override
    public final String getClassSignature() {
        return this.classSignature;
    }

    @Override
    public String toString() {
        Object result = "AbstractOperationEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "operationSignature = ";
        result = (String)result + this.getOperationSignature() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        return result;
    }
}

