/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IExceptionRecord;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class AfterOperationFailedEvent
extends AfterOperationEvent
implements IExceptionRecord {
    public static final int SIZE = 32;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "cause"};
    public static final String CAUSE = "";
    private static final long serialVersionUID = -235912152331253573L;
    private final String cause;

    public AfterOperationFailedEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String cause) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
        this.cause = cause == null ? CAUSE : cause;
    }

    public AfterOperationFailedEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.cause = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putString(this.getCause());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AfterOperationFailedEvent castedRecord = (AfterOperationFailedEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        return this.getCause().equals(castedRecord.getCause());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        return code += this.getCause().hashCode();
    }

    @Override
    public final String getCause() {
        return this.cause;
    }

    @Override
    public String toString() {
        Object result = "AfterOperationFailedEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "operationSignature = ";
        result = (String)result + this.getOperationSignature() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        result = (String)result + "cause = ";
        result = (String)result + this.getCause() + ", ";
        return result;
    }
}

