/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;

public abstract class AbstractJVMRecord
extends AbstractMonitoringRecord {
    public static final String HOSTNAME = "";
    public static final String VM_NAME = "";
    private static final long serialVersionUID = -961661872949303914L;
    private final long timestamp;
    private final String hostname;
    private final String vmName;

    public AbstractJVMRecord(long timestamp, String hostname, String vmName) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.vmName = vmName == null ? "" : vmName;
    }

    public AbstractJVMRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.vmName = deserializer.getString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractJVMRecord castedRecord = (AbstractJVMRecord)obj;
        return this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getTimestamp() == castedRecord.getTimestamp() && this.getHostname().equals(castedRecord.getHostname()) && this.getVmName().equals(castedRecord.getVmName());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        return code += this.getVmName().hashCode();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getVmName() {
        return this.vmName;
    }

    @Override
    public String toString() {
        Object result = "AbstractJVMRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "vmName = ";
        result = (String)result + this.getVmName() + ", ";
        return result;
    }
}

