/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.jvm.AbstractJVMRecord;

public class ThreadsStatusRecord
extends AbstractJVMRecord {
    public static final int SIZE = 48;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "vmName", "threadCount", "daemonThreadCount", "peakThreadCount", "totalStartedThreadCount"};
    private static final long serialVersionUID = -9176980438135391329L;
    private final long threadCount;
    private final long daemonThreadCount;
    private final long peakThreadCount;
    private final long totalStartedThreadCount;

    public ThreadsStatusRecord(long timestamp, String hostname, String vmName, long threadCount, long daemonThreadCount, long peakThreadCount, long totalStartedThreadCount) {
        super(timestamp, hostname, vmName);
        this.threadCount = threadCount;
        this.daemonThreadCount = daemonThreadCount;
        this.peakThreadCount = peakThreadCount;
        this.totalStartedThreadCount = totalStartedThreadCount;
    }

    public ThreadsStatusRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.threadCount = deserializer.getLong();
        this.daemonThreadCount = deserializer.getLong();
        this.peakThreadCount = deserializer.getLong();
        this.totalStartedThreadCount = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getVmName());
        serializer.putLong(this.getThreadCount());
        serializer.putLong(this.getDaemonThreadCount());
        serializer.putLong(this.getPeakThreadCount());
        serializer.putLong(this.getTotalStartedThreadCount());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 48;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ThreadsStatusRecord castedRecord = (ThreadsStatusRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getHostname().equals(castedRecord.getHostname()) || !this.getVmName().equals(castedRecord.getVmName())) {
            return false;
        }
        if (this.getThreadCount() != castedRecord.getThreadCount()) {
            return false;
        }
        if (this.getDaemonThreadCount() != castedRecord.getDaemonThreadCount()) {
            return false;
        }
        if (this.getPeakThreadCount() != castedRecord.getPeakThreadCount()) {
            return false;
        }
        return this.getTotalStartedThreadCount() == castedRecord.getTotalStartedThreadCount();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getVmName().hashCode();
        code += (int)this.getThreadCount();
        code += (int)this.getDaemonThreadCount();
        code += (int)this.getPeakThreadCount();
        return code += (int)this.getTotalStartedThreadCount();
    }

    public final long getThreadCount() {
        return this.threadCount;
    }

    public final long getDaemonThreadCount() {
        return this.daemonThreadCount;
    }

    public final long getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public final long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount;
    }

    @Override
    public String toString() {
        Object result = "ThreadsStatusRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "vmName = ";
        result = (String)result + this.getVmName() + ", ";
        result = (String)result + "threadCount = ";
        result = (String)result + this.getThreadCount() + ", ";
        result = (String)result + "daemonThreadCount = ";
        result = (String)result + this.getDaemonThreadCount() + ", ";
        result = (String)result + "peakThreadCount = ";
        result = (String)result + this.getPeakThreadCount() + ", ";
        result = (String)result + "totalStartedThreadCount = ";
        result = (String)result + this.getTotalStartedThreadCount() + ", ";
        return result;
    }
}

