/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class HostApplicationMetaData
extends AbstractMonitoringRecord {
    public static final int SIZE = 16;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"systemName", "ipAddress", "hostname", "applicationName"};
    public static final String SYSTEM_NAME = "";
    public static final String IP_ADDRESS = "";
    public static final String HOSTNAME = "";
    public static final String APPLICATION_NAME = "";
    private static final long serialVersionUID = 5425789809172379297L;
    private final String systemName;
    private final String ipAddress;
    private final String hostname;
    private final String applicationName;

    public HostApplicationMetaData(String systemName, String ipAddress, String hostname, String applicationName) {
        this.systemName = systemName == null ? "" : systemName;
        this.ipAddress = ipAddress == null ? "" : ipAddress;
        this.hostname = hostname == null ? "" : hostname;
        this.applicationName = applicationName == null ? "" : applicationName;
    }

    public HostApplicationMetaData(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.systemName = deserializer.getString();
        this.ipAddress = deserializer.getString();
        this.hostname = deserializer.getString();
        this.applicationName = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getSystemName());
        serializer.putString(this.getIpAddress());
        serializer.putString(this.getHostname());
        serializer.putString(this.getApplicationName());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HostApplicationMetaData castedRecord = (HostApplicationMetaData)obj;
        if (!(this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getSystemName().equals(castedRecord.getSystemName()) && this.getIpAddress().equals(castedRecord.getIpAddress()) && this.getHostname().equals(castedRecord.getHostname()))) {
            return false;
        }
        return this.getApplicationName().equals(castedRecord.getApplicationName());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getSystemName().hashCode();
        code += this.getIpAddress().hashCode();
        code += this.getHostname().hashCode();
        return code += this.getApplicationName().hashCode();
    }

    public final String getSystemName() {
        return this.systemName;
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String toString() {
        Object result = "HostApplicationMetaData: ";
        result = (String)result + "systemName = ";
        result = (String)result + this.getSystemName() + ", ";
        result = (String)result + "ipAddress = ";
        result = (String)result + this.getIpAddress() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "applicationName = ";
        result = (String)result + this.getApplicationName() + ", ";
        return result;
    }
}

