/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.session;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.flow.IEventRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.session.ISessionEvent;

public class SessionEndEvent
extends AbstractMonitoringRecord
implements IEventRecord,
ISessionEvent {
    public static final int SIZE = 16;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "sessionId"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String SESSION_ID = "";
    private static final long serialVersionUID = -7471486980805589930L;
    private long timestamp;
    private final String hostname;
    private final String sessionId;

    public SessionEndEvent(long timestamp, String hostname, String sessionId) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.sessionId = sessionId == null ? "" : sessionId;
    }

    public SessionEndEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.sessionId = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getSessionId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SessionEndEvent castedRecord = (SessionEndEvent)obj;
        return this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getTimestamp() == castedRecord.getTimestamp() && this.getHostname().equals(castedRecord.getHostname()) && this.getSessionId().equals(castedRecord.getSessionId());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        return code += this.getSessionId().hashCode();
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public final void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public final String getHostname() {
        return this.hostname;
    }

    @Override
    public final String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String toString() {
        Object result = "SessionEndEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "sessionId = ";
        result = (String)result + this.getSessionId() + ", ";
        return result;
    }
}

