/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.KiekerMetadataRecord;
import kieker.common.util.Version;
import kieker.monitoring.core.configuration.ConfigurationFactory;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.IStateListener;
import kieker.monitoring.core.controller.JMXController;
import kieker.monitoring.core.controller.ProbeController;
import kieker.monitoring.core.controller.SamplingController;
import kieker.monitoring.core.controller.StateController;
import kieker.monitoring.core.controller.TCPController;
import kieker.monitoring.core.controller.TimeSourceController;
import kieker.monitoring.core.controller.WriterController;
import kieker.monitoring.core.sampler.ISampler;
import kieker.monitoring.core.sampler.ScheduledSamplerJob;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitoringController
extends AbstractController
implements IMonitoringController,
IStateListener {
    static final Logger LOGGER = LoggerFactory.getLogger(MonitoringController.class);
    private static final long SHUTDOWN_DELAY_MILLIS = 1000L;
    private final StateController stateController;
    private final SamplingController samplingController;
    private final JMXController jmxController;
    private final TCPController tcpController;
    private final WriterController writerController;
    private final TimeSourceController timeSourceController;
    private final ProbeController probeController;
    private final boolean autoSetLoggingTimestamp;

    private MonitoringController(Configuration configuration) {
        super(configuration);
        this.stateController = new StateController(configuration);
        this.samplingController = new SamplingController(configuration);
        this.jmxController = new JMXController(configuration);
        this.tcpController = new TCPController(configuration, this);
        this.writerController = new WriterController(configuration);
        this.stateController.setStateListener(this);
        this.timeSourceController = new TimeSourceController(configuration);
        this.probeController = new ProbeController(configuration);
        this.autoSetLoggingTimestamp = configuration.getBooleanProperty("kieker.monitoring.setLoggingTimestamp");
    }

    public static MonitoringController createInstance(Configuration configuration) {
        final MonitoringController monitoringController = new MonitoringController(configuration);
        monitoringController.stateController.setMonitoringController(monitoringController);
        if (monitoringController.stateController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.samplingController.setMonitoringController(monitoringController);
        if (monitoringController.samplingController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.jmxController.setMonitoringController(monitoringController);
        if (monitoringController.jmxController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.tcpController.setMonitoringController(monitoringController);
        if (monitoringController.tcpController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.writerController.setMonitoringController(monitoringController);
        if (monitoringController.writerController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.timeSourceController.setMonitoringController(monitoringController);
        if (monitoringController.timeSourceController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.probeController.setMonitoringController(monitoringController);
        if (monitoringController.probeController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.setMonitoringController(monitoringController);
        if (monitoringController.isTerminated()) {
            return monitoringController;
        }
        if (monitoringController.isMonitoringEnabled()) {
            monitoringController.enableMonitoring();
        }
        if (configuration.getBooleanProperty("kieker.monitoring.useShutdownHook")) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (!monitoringController.isMonitoringTerminated()) {
                            LOGGER.info("ShutdownHook notifies controller to initiate shutdown.");
                            monitoringController.terminateMonitoring();
                            try {
                                monitoringController.waitForTermination(1000L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.warn("Shutdown was interrupted while waiting");
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn("Failed to add shutdownHook");
            }
        } else {
            LOGGER.warn("Shutdown Hook is disabled, loss of monitoring data might occur.");
        }
        LOGGER.info(monitoringController.toString());
        return monitoringController;
    }

    public static String getVersion() {
        return Version.getVERSION();
    }

    @Override
    public void beforeEnableMonitoring() {
        if (this.writerController.isLogMetadataRecord()) {
            this.sendMetadataAsRecord();
        }
    }

    @Override
    protected void init() {
    }

    @Override
    protected void cleanup() {
        LOGGER.info("Shutting down Monitoring Controller ({})", (Object)this.getName());
        this.probeController.terminate();
        this.timeSourceController.terminate();
        this.writerController.terminate();
        this.jmxController.terminate();
        this.tcpController.terminate();
        this.samplingController.terminate();
        this.stateController.terminate();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2048).append("Current State of kieker.monitoring (").append(MonitoringController.getVersion()).append(") ").append(this.stateController.toString()).append(this.jmxController.toString()).append(this.timeSourceController.toString()).append(this.probeController.toString()).append(this.writerController.toString()).append("\n\tAutomatic assignment of logging timestamps: '").append(this.autoSetLoggingTimestamp).append("'\n").append(this.samplingController.toString());
        return sb.toString();
    }

    @Override
    public boolean sendMetadataAsRecord() {
        ITimeSource timesource = this.getTimeSource();
        return this.newMonitoringRecord(new KiekerMetadataRecord(null, this.getName(), this.getHostname(), this.getExperimentId(), this.isDebug(), timesource.getOffset(), timesource.getTimeUnit().name(), 0L));
    }

    protected SamplingController getSamplingController() {
        return this.samplingController;
    }

    @Override
    public boolean terminateMonitoring() {
        LOGGER.info("Terminating monitoring...");
        return this.stateController.terminateMonitoring();
    }

    @Override
    public boolean isMonitoringTerminated() {
        return this.stateController.isMonitoringTerminated();
    }

    @Override
    public boolean enableMonitoring() {
        return this.stateController.enableMonitoring();
    }

    @Override
    public boolean disableMonitoring() {
        return this.stateController.disableMonitoring();
    }

    @Override
    public boolean isMonitoringEnabled() {
        return this.stateController.isMonitoringEnabled();
    }

    @Override
    public boolean isDebug() {
        return this.stateController.isDebug();
    }

    @Override
    public String getName() {
        return this.stateController.getName();
    }

    @Override
    public String getHostname() {
        return this.stateController.getHostname();
    }

    @Override
    public String getApplicationName() {
        return this.stateController.getApplicationName();
    }

    @Override
    public int incExperimentId() {
        return this.stateController.incExperimentId();
    }

    @Override
    public void setExperimentId(int newExperimentID) {
        this.stateController.setExperimentId(newExperimentID);
    }

    @Override
    public int getExperimentId() {
        return this.stateController.getExperimentId();
    }

    @Override
    public boolean newMonitoringRecord(IMonitoringRecord record) {
        if (!this.isMonitoringEnabled()) {
            return false;
        }
        if (this.autoSetLoggingTimestamp) {
            record.setLoggingTimestamp(this.getTimeSource().getTime());
        }
        return this.writerController.newMonitoringRecord(record);
    }

    @Override
    public void waitForTermination(long timeoutInMs) throws InterruptedException {
        this.writerController.waitForTermination(timeoutInMs);
    }

    @Override
    public ScheduledSamplerJob schedulePeriodicSampler(ISampler sampler, long initialDelay, long period, TimeUnit timeUnit) {
        return this.samplingController.schedulePeriodicSampler(sampler, initialDelay, period, timeUnit);
    }

    @Override
    public boolean removeScheduledSampler(ScheduledSamplerJob sampler) {
        return this.samplingController.removeScheduledSampler(sampler);
    }

    @Override
    public ITimeSource getTimeSource() {
        return this.timeSourceController.getTimeSource();
    }

    @Override
    public String getControllerDomain() {
        return this.jmxController.getControllerDomain();
    }

    @Override
    public boolean activateProbe(String pattern) {
        return this.probeController.activateProbe(pattern);
    }

    @Override
    public boolean deactivateProbe(String pattern) {
        return this.probeController.deactivateProbe(pattern);
    }

    @Override
    public boolean isProbeActivated(String signature) {
        return this.probeController.isProbeActivated(signature);
    }

    @Override
    public void setProbePatternList(List<String> patternList) {
        this.probeController.setProbePatternList(patternList);
    }

    @Override
    public List<String> getProbePatternList() {
        return this.probeController.getProbePatternList();
    }

    @Override
    public Map<String, List<String>> getAllPatternParameters(String pattern) {
        return this.probeController.getAllPatternParameters(pattern);
    }

    @Override
    public void deletePatternParameter(String pattern, String parameterName) {
        this.probeController.deletePatternParameter(pattern, parameterName);
    }

    @Override
    public void clearPatternParameters(String pattern) {
        this.probeController.clearPatternParameters(pattern);
    }

    @Override
    public void addPatternParameter(String pattern, String parameterName, List<String> parameters) {
        this.probeController.addPatternParameter(pattern, parameterName, parameters);
    }

    @Override
    public void addPatternParameterValue(String pattern, String name, String value) {
        this.probeController.addPatternParameterValue(pattern, name, value);
    }

    @Override
    public void removePatternParameterValue(String pattern, String name, String value) {
        this.probeController.removePatternParameterValue(pattern, name, value);
    }

    public static IMonitoringController getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private static final class SingletonHelper {
        static final IMonitoringController INSTANCE = MonitoringController.createInstance(ConfigurationFactory.createSingletonConfiguration());

        private SingletonHelper() {
        }
    }
}

