/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.IRecordReceivedListener;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;

public class TcpRecordReader
implements Runnable {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private static final int CONNECTION_CLOSED_BY_CLIENT = -1;
    private final Logger logger;
    private final int port;
    private final int bufferCapacity;
    private volatile boolean terminated;
    private final boolean respawn;
    private final ReaderRegistry<String> readerRegistry = new ReaderRegistry();
    private final IRecordReceivedListener listener;
    private final CachedRecordFactoryCatalog recordFactories = new CachedRecordFactoryCatalog();

    public TcpRecordReader(int port, int bufferCapacity, Logger logger, IRecordReceivedListener listener) {
        this(port, bufferCapacity, logger, false, listener);
    }

    public TcpRecordReader(int port, int bufferCapacity, Logger logger, boolean respawn, IRecordReceivedListener listener) {
        this.port = port;
        this.bufferCapacity = bufferCapacity;
        this.logger = logger;
        this.respawn = respawn;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port));
            do {
                this.logger.debug("Listening on port {}", (Object)this.port);
                try (SocketChannel socketChannel = serversocket.accept();){
                    ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferCapacity);
                    while (socketChannel.read(buffer) != -1 && !this.terminated) {
                        this.process(buffer);
                    }
                }
            } while (!this.terminated && this.respawn);
        }
        catch (IOException ex) {
            this.logger.error("Error while receiving control commands.", ex);
        }
        finally {
            if (null != serversocket) {
                try {
                    serversocket.close();
                }
                catch (IOException e) {
                    this.logger.debug("Failed to close TCP connection.", e);
                }
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    public int getPort() {
        return this.port;
    }

    public boolean onBufferReceived(ByteBuffer buffer) {
        if (buffer.remaining() >= 4) {
            int clazzId = buffer.getInt();
            if (clazzId == -1) {
                return this.registerEntry(buffer);
            }
            return this.deserializeRecord(clazzId, buffer);
        }
        return false;
    }

    private boolean registerEntry(ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            int id = buffer.getInt();
            int stringLength = buffer.getInt();
            if (buffer.remaining() < stringLength) {
                return false;
            }
            byte[] strBytes = new byte[stringLength];
            buffer.get(strBytes);
            String string = new String(strBytes, ENCODING);
            this.readerRegistry.register(id, string);
            return true;
        }
        return false;
    }

    private boolean deserializeRecord(int clazzId, ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            long loggingTimestamp = buffer.getLong();
            String recordClassName = this.readerRegistry.get(clazzId);
            if (recordClassName != null) {
                IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
                if (buffer.remaining() >= recordFactory.getRecordSizeInBytes()) {
                    try {
                        IMonitoringRecord record = recordFactory.create(BinaryValueDeserializer.create(buffer, this.readerRegistry));
                        record.setLoggingTimestamp(loggingTimestamp);
                        this.listener.onRecordReceived(record);
                        return true;
                    }
                    catch (BufferUnderflowException ex) {
                        this.logger.warn("Cannot create {}; missing data in byte buffer. Buffer remaining {}", (Object)recordClassName, (Object)buffer.remaining());
                        return false;
                    }
                    catch (RecordInstantiationException ex) {
                        this.logger.error("Failed to create {}", (Object)recordClassName, (Object)ex);
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void process(ByteBuffer buffer) {
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                buffer.mark();
                boolean success = this.onBufferReceived(buffer);
                if (success) continue;
                buffer.reset();
                buffer.compact();
                return;
            }
            buffer.clear();
        }
        catch (BufferUnderflowException ex) {
            this.logger.warn("Unexpected buffer underflow. Resetting and compacting buffer.", ex);
            buffer.reset();
            buffer.compact();
        }
    }
}

