/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.signaturePattern;

import java.io.Serializable;
import java.util.regex.Pattern;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;
import kieker.monitoring.core.signaturePattern.PatternParser;

public class PatternEntry
implements Serializable {
    private static final long serialVersionUID = 6225456449265043944L;
    private final Pattern pattern;
    private final String strPattern;
    private final boolean activated;

    public PatternEntry(String strPattern, boolean activated) throws InvalidPatternException {
        this.pattern = PatternParser.parseToPattern(strPattern);
        this.strPattern = strPattern;
        this.activated = activated;
    }

    public PatternEntry(String strPattern, Pattern pattern, boolean activated) {
        this.pattern = pattern;
        this.strPattern = strPattern;
        this.activated = activated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.strPattern == null ? 0 : this.strPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatternEntry other = (PatternEntry)obj;
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        return !(this.strPattern == null ? other.strPattern != null : !this.strPattern.equals(other.strPattern));
    }

    public String toString() {
        return "PatternEntry [pattern=" + this.pattern + ", strPattern=" + this.strPattern + ", activated=" + this.activated + "]";
    }

    public String getStrPattern() {
        return this.strPattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isActivated() {
        return this.activated;
    }
}

