/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj;

import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.monitoring.probe.IMonitoringProbe;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public abstract class AbstractAspectJProbe
implements IMonitoringProbe {
    private final ConcurrentMap<Signature, String> signatureCache = new ConcurrentHashMap<Signature, String>();

    @Pointcut(value="!within(kieker.common..*) && !within(kieker.monitoring..*) && !within(kieker.analysis..*) && !within(kieker.tools..*)")
    public void notWithinKieker() {
    }

    @Pointcut(value="execution(void set*(..)) || call(void set*(..))")
    public void setter() {
    }

    @Pointcut(value="execution(* get*(..)) || call(* get*(..)) || execution(boolean is*(..)) || call(boolean is*(..))")
    public void getter() {
    }

    @Pointcut(value="!getter() && !setter()")
    public void noGetterAndSetter() {
    }

    protected String signatureToLongString(Signature sig) {
        String signatureString = (String)this.signatureCache.get(sig);
        if (null != signatureString) {
            return signatureString;
        }
        if (sig instanceof MethodSignature) {
            MethodSignature signature = (MethodSignature)sig;
            StringBuilder sb = new StringBuilder(256);
            String modString = Modifier.toString(signature.getModifiers());
            sb.append(modString);
            if (modString.length() > 0) {
                sb.append(' ');
            }
            this.addType(sb, signature.getReturnType());
            sb.append(' ').append(signature.getDeclaringTypeName()).append('.').append(signature.getName()).append('(');
            this.addTypeList(sb, signature.getParameterTypes());
            sb.append(')');
            signatureString = sb.toString();
        } else if (sig instanceof ConstructorSignature) {
            ConstructorSignature signature = (ConstructorSignature)sig;
            StringBuilder sb = new StringBuilder(256);
            String modString = Modifier.toString(signature.getModifiers());
            sb.append(modString);
            if (modString.length() > 0) {
                sb.append(' ');
            }
            sb.append(signature.getDeclaringTypeName()).append('.').append(signature.getName()).append('(');
            this.addTypeList(sb, signature.getParameterTypes());
            sb.append(')');
            signatureString = sb.toString();
        } else {
            signatureString = sig.toLongString();
        }
        this.signatureCache.putIfAbsent(sig, signatureString);
        return signatureString;
    }

    private final StringBuilder addTypeList(StringBuilder sb, Class<?>[] clazzes) {
        if (null != clazzes) {
            boolean first = true;
            for (Class<?> clazz : clazzes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                this.addType(sb, clazz);
            }
        }
        return sb;
    }

    private final StringBuilder addType(StringBuilder sb, Class<?> clazz) {
        if (null == clazz) {
            sb.append("ANONYMOUS");
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            this.addType(sb, componentType);
            sb.append("[]");
        } else {
            sb.append(clazz.getName());
        }
        return sb;
    }
}

