/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.flow.concurrency;

import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.concurrency.SplitEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class ThreadingAspect
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ThreadingAspect ajc$perSingletonInstance;

    @Before(value="call(void java.lang.Thread.start()) && target(thread) && notWithinKieker()")
    public void beforeNewThread(Thread thread) {
        if (!CTRLINST.isMonitoringEnabled() || !CTRLINST.isProbeActivated("public synchronized void java.lang.Thread.start()")) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        if (trace != null) {
            long traceId = trace.getTraceId();
            int orderId = trace.getNextOrderId();
            TRACEREGISTRY.setParentTraceId(thread, traceId, orderId);
            CTRLINST.newMonitoringRecord(new SplitEvent(TIME.getTime(), traceId, orderId));
        }
    }

    static {
        try {
            ThreadingAspect.ajc$perSingletonInstance = new ThreadingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ThreadingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("kieker.monitoring.probe.aspectj.flow.concurrency.ThreadingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

