/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.jersey;

import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclarePrecedence;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
@DeclarePrecedence(value="kieker.monitoring.probe.aspectj.jersey.*,kieker.monitoring.probe.aspectj.operationExecution.*")
public class OperationExecutionJerseyServerInterceptor
extends AbstractAspectJProbe {
    public static final String SESSION_ID_ASYNC_TRACE = "NOSESSION-ASYNCIN";
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutionJerseyServerInterceptor.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String VMNAME = CTRLINST.getHostname();
    private static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    private static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ OperationExecutionJerseyServerInterceptor ajc$perSingletonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(private void com.sun.jersey.server.impl.application.WebApplicationImpl._handleRequest(com.sun.jersey.server.impl.application.WebApplicationContext, com.sun.jersey.spi.container.ContainerRequest, com.sun.jersey.spi.container.ContainerResponse))")
    public Object operationHandleRequest(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        Object retval;
        int ess;
        int eoi;
        if (!OperationExecutionJerseyServerInterceptor.CTRLINST.isMonitoringEnabled()) {
            return thisJoinPoint.proceed();
        }
        String signature = this.ajc$superDispatch$kieker_monitoring_probe_aspectj_jersey_OperationExecutionJerseyServerInterceptor$signatureToLongString(thisJoinPoint.getSignature());
        if (!OperationExecutionJerseyServerInterceptor.CTRLINST.isProbeActivated(signature)) {
            return thisJoinPoint.proceed();
        }
        boolean entrypoint = true;
        String hostname = OperationExecutionJerseyServerInterceptor.VMNAME;
        String sessionId = OperationExecutionJerseyServerInterceptor.SESSION_REGISTRY.recallThreadLocalSessionId();
        Long traceId = -1L;
        Object[] args = thisJoinPoint.getArgs();
        ContainerRequest request = (ContainerRequest)args[1];
        MultivaluedMap requestHeader = request.getRequestHeaders();
        List requestJerseyHeader = (List)requestHeader.get((Object)"OperationExecutionJerseyHeader");
        if (requestJerseyHeader == null || requestJerseyHeader.isEmpty()) {
            OperationExecutionJerseyServerInterceptor.LOGGER.debug("No monitoring data found in the incoming request header");
            traceId = OperationExecutionJerseyServerInterceptor.CF_REGISTRY.getAndStoreUniqueThreadLocalTraceId();
            OperationExecutionJerseyServerInterceptor.CF_REGISTRY.storeThreadLocalEOI(0);
            OperationExecutionJerseyServerInterceptor.CF_REGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
        } else {
            String operationExecutionHeader = (String)requestJerseyHeader.get(0);
            OperationExecutionJerseyServerInterceptor.LOGGER.debug("Received request: {} with header = {}", (Object)request.getRequestUri(), (Object)requestHeader.toString());
            String[] headerArray = operationExecutionHeader.split(",");
            sessionId = headerArray[1];
            if ("null".equals(sessionId)) {
                sessionId = "<no-session-id>";
            }
            String eoiStr = headerArray[2];
            eoi = -1;
            try {
                eoi = 1 + Integer.parseInt(eoiStr);
            }
            catch (NumberFormatException exc) {
                OperationExecutionJerseyServerInterceptor.LOGGER.warn("Invalid eoi", exc);
            }
            String essStr = headerArray[3];
            ess = -1;
            try {
                ess = Integer.parseInt(essStr);
            }
            catch (NumberFormatException exc) {
                OperationExecutionJerseyServerInterceptor.LOGGER.warn("Invalid ess", exc);
            }
            String traceIdStr = headerArray[0];
            if (traceIdStr != null) {
                try {
                    traceId = Long.parseLong(traceIdStr);
                }
                catch (NumberFormatException exc) {
                    OperationExecutionJerseyServerInterceptor.LOGGER.warn("Invalid trace id", exc);
                }
            } else {
                traceId = OperationExecutionJerseyServerInterceptor.CF_REGISTRY.getUniqueTraceId();
                sessionId = SESSION_ID_ASYNC_TRACE;
                entrypoint = true;
                eoi = 0;
                ess = 0;
            }
            OperationExecutionJerseyServerInterceptor.CF_REGISTRY.storeThreadLocalTraceId(traceId);
            OperationExecutionJerseyServerInterceptor.CF_REGISTRY.storeThreadLocalEOI(eoi);
            OperationExecutionJerseyServerInterceptor.CF_REGISTRY.storeThreadLocalESS(ess + 1);
            OperationExecutionJerseyServerInterceptor.SESSION_REGISTRY.storeThreadLocalSessionId(sessionId);
        }
        long tin = OperationExecutionJerseyServerInterceptor.TIME.getTime();
        try {
            retval = thisJoinPoint.proceed();
        }
        finally {
            long tout = OperationExecutionJerseyServerInterceptor.TIME.getTime();
            OperationExecutionJerseyServerInterceptor.CTRLINST.newMonitoringRecord(new OperationExecutionRecord(signature, sessionId, traceId, tin, tout, hostname, eoi, ess));
            if (entrypoint) {
                this.unsetKiekerThreadLocalData();
            } else {
                OperationExecutionJerseyServerInterceptor.CF_REGISTRY.storeThreadLocalESS(ess);
            }
        }
        return retval;
    }

    @Around(value="execution(public void com.sun.jersey.spi.container.ContainerResponse.write())")
    public Object operationWriteResponse(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        if (!OperationExecutionJerseyServerInterceptor.CTRLINST.isMonitoringEnabled()) {
            return thisJoinPoint.proceed();
        }
        String signature = this.ajc$superDispatch$kieker_monitoring_probe_aspectj_jersey_OperationExecutionJerseyServerInterceptor$signatureToLongString(thisJoinPoint.getSignature());
        if (!OperationExecutionJerseyServerInterceptor.CTRLINST.isProbeActivated(signature)) {
            return thisJoinPoint.proceed();
        }
        long traceId = OperationExecutionJerseyServerInterceptor.CF_REGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            OperationExecutionJerseyServerInterceptor.LOGGER.warn("Kieker traceId not registered. Will unset all threadLocal variables and return.");
            return thisJoinPoint.proceed();
        }
        String sessionId = OperationExecutionJerseyServerInterceptor.SESSION_REGISTRY.recallThreadLocalSessionId();
        ContainerResponse containerResponse = (ContainerResponse)thisJoinPoint.getTarget();
        MultivaluedMap responseHeader = containerResponse.getHeaders();
        ArrayList<CallSite> responseHeaderList = new ArrayList<CallSite>();
        responseHeaderList.add((CallSite)((Object)(Long.toString(traceId) + "," + sessionId + "," + Integer.toString(OperationExecutionJerseyServerInterceptor.CF_REGISTRY.recallThreadLocalEOI()))));
        responseHeader.put((Object)"OperationExecutionJerseyHeader", responseHeaderList);
        LOGGER.debug("Sending response with header = {} to the request: {}", (Object)responseHeader.toString(), (Object)containerResponse.getRequestContext().getRequestUri());
        return thisJoinPoint.proceed();
    }

    private final void unsetKiekerThreadLocalData() {
        CF_REGISTRY.unsetThreadLocalTraceId();
        CF_REGISTRY.unsetThreadLocalEOI();
        CF_REGISTRY.unsetThreadLocalESS();
    }

    static {
        try {
            OperationExecutionJerseyServerInterceptor.ajc$perSingletonInstance = new OperationExecutionJerseyServerInterceptor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static OperationExecutionJerseyServerInterceptor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("kieker.monitoring.probe.aspectj.jersey.OperationExecutionJerseyServerInterceptor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public /* synthetic */ String ajc$superDispatch$kieker_monitoring_probe_aspectj_jersey_OperationExecutionJerseyServerInterceptor$signatureToLongString(Signature signature) {
        return super.signatureToLongString(signature);
    }
}

