/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.operationExecution;

import java.util.Stack;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.probe.utilities.OperationStartData;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public abstract class AbstractOperationExecutionAspect
extends AbstractAspectJProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperationExecutionAspect.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String VMNAME = CTRLINST.getHostname();
    private static final ControlFlowRegistry CFREGISTRY = ControlFlowRegistry.INSTANCE;
    private static final SessionRegistry SESSIONREGISTRY = SessionRegistry.INSTANCE;
    private final ThreadLocal<Stack<OperationStartData>> stack = new ThreadLocal<Stack<OperationStartData>>(){

        @Override
        protected Stack<OperationStartData> initialValue() {
            return new Stack<OperationStartData>();
        }
    };

    @Pointcut
    public abstract void monitoredOperation();

    @Before(value="monitoredOperation() && notWithinKieker()")
    public void beforeOperation(JoinPoint thisJoinPoint) throws Throwable {
        int ess;
        int eoi;
        boolean entrypoint;
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(thisJoinPoint.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        long traceId = CFREGISTRY.recallThreadLocalTraceId();
        if (traceId == -1L) {
            entrypoint = true;
            traceId = CFREGISTRY.getAndStoreUniqueThreadLocalTraceId();
            CFREGISTRY.storeThreadLocalEOI(0);
            CFREGISTRY.storeThreadLocalESS(1);
            eoi = 0;
            ess = 0;
        } else {
            entrypoint = false;
            eoi = CFREGISTRY.incrementAndRecallThreadLocalEOI();
            ess = CFREGISTRY.recallAndIncrementThreadLocalESS();
            if (eoi == -1 || ess == -1) {
                LOGGER.error("eoi and/or ess have invalid values: eoi == {} ess == {}", (Object)eoi, (Object)ess);
                CTRLINST.terminateMonitoring();
            }
        }
        long tin = TIME.getTime();
        OperationStartData data = new OperationStartData(entrypoint, traceId, tin, eoi, ess);
        this.stack.get().push(data);
    }

    @After(value="monitoredOperation() && notWithinKieker()")
    public void afterOperation(JoinPoint thisJoinPoint) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.signatureToLongString(thisJoinPoint.getSignature());
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        OperationStartData data = this.stack.get().pop();
        long tout = TIME.getTime();
        String hostname = VMNAME;
        String sessionId = SESSIONREGISTRY.recallThreadLocalSessionId();
        CTRLINST.newMonitoringRecord(new OperationExecutionRecord(operationSignature, sessionId, data.getTraceId(), data.getTin(), tout, hostname, data.getEoi(), data.getEss()));
        if (data.isEntrypoint()) {
            CFREGISTRY.unsetThreadLocalTraceId();
            CFREGISTRY.unsetThreadLocalEOI();
            CFREGISTRY.unsetThreadLocalESS();
        } else {
            CFREGISTRY.storeThreadLocalESS(data.getEss());
        }
    }
}

