/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.queue.behavior;

import java.util.concurrent.BlockingQueue;
import kieker.monitoring.queue.behavior.InsertBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOnFailedInsertBehavior<E>
implements InsertBehavior<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockOnFailedInsertBehavior.class);
    private final BlockingQueue<E> queue;
    private int numBlocked;

    public BlockOnFailedInsertBehavior(BlockingQueue<E> queue) {
        this.queue = queue;
    }

    @Override
    public boolean insert(E element) {
        boolean offered = this.queue.offer(element);
        if (offered) {
            return true;
        }
        try {
            this.queue.put(element);
            ++this.numBlocked;
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when adding new monitoring record to queue.", e);
            LOGGER.error("Failed to add new monitoring record to queue (maximum number of attempts reached).");
            return false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(50).append(this.getClass()).append("\n\t\t").append("numBlocked: ").append(this.numBlocked);
        return builder.toString();
    }
}

