/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.mxbean;

import java.lang.management.ManagementFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.sampler.ISampler;

public abstract class AbstractMXBeanSampler
implements ISampler {
    private static final String VM_NAME = ManagementFactory.getRuntimeMXBean().getName();

    @Override
    public final void sample(IMonitoringController monitoringController) throws Exception {
        IMonitoringRecord[] records;
        if (!monitoringController.isMonitoringEnabled()) {
            return;
        }
        long timestamp = monitoringController.getTimeSource().getTime();
        String hostname = monitoringController.getHostname();
        for (IMonitoringRecord record : records = this.createNewMonitoringRecords(timestamp, hostname, VM_NAME, monitoringController)) {
            monitoringController.newMonitoringRecord(record);
        }
    }

    protected abstract IMonitoringRecord[] createNewMonitoringRecords(long var1, String var3, String var4, IMonitoringController var5);
}

