/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import kieker.common.record.system.ResourceUtilizationRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.oshi.samplers.AbstractOshiSampler;
import kieker.monitoring.timer.ITimeSource;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public class CPUsCombinedPercSampler
extends AbstractOshiSampler {
    private static final String CPU_RESOURCE_NAME_PREFIX = "cpu-";

    public CPUsCombinedPercSampler(HardwareAbstractionLayer hardwareAbstractionLayer) {
        super(hardwareAbstractionLayer);
    }

    @Override
    public void sample(IMonitoringController monitoringController) {
        if (!monitoringController.isMonitoringEnabled() || !monitoringController.isProbeActivated(SignatureFactory.createCPUSignature())) {
            return;
        }
        CentralProcessor centralProcessor = this.hardwareAbstractionLayer.getProcessor();
        double[] cpuLoads = centralProcessor.getProcessorCpuLoad(10L);
        ITimeSource timesource = monitoringController.getTimeSource();
        for (int i = 0; i < cpuLoads.length; ++i) {
            if (!monitoringController.isProbeActivated(SignatureFactory.createCPUSignature(i))) continue;
            double combinedUtilization = cpuLoads[i];
            ResourceUtilizationRecord r = new ResourceUtilizationRecord(timesource.getTime(), monitoringController.getHostname(), CPU_RESOURCE_NAME_PREFIX + i, combinedUtilization);
            monitoringController.newMonitoringRecord(r);
        }
    }
}

