/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.oshi.samplers;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.common.record.system.DiskUsageRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.oshi.samplers.AbstractOshiSampler;
import kieker.monitoring.timer.ITimeSource;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;

public final class DiskUsageSampler
extends AbstractOshiSampler {
    private final ConcurrentHashMap<String, DiskUsageStatistic> diskUsageStatisticMap = new ConcurrentHashMap();

    public DiskUsageSampler(HardwareAbstractionLayer hardwareAbstractionLayer) {
        super(hardwareAbstractionLayer);
    }

    @Override
    public void sample(IMonitoringController monitoringController) {
        if (!monitoringController.isMonitoringEnabled() || !monitoringController.isProbeActivated(SignatureFactory.createDiskUsageSignature())) {
            return;
        }
        List hwDistStores = this.hardwareAbstractionLayer.getDiskStores();
        for (HWDiskStore hwDistStore : hwDistStores) {
            String deviceName = hwDistStore.getName();
            ITimeSource timesource = monitoringController.getTimeSource();
            TimeUnit timeUnit = timesource.getTimeUnit();
            DiskUsageStatistic currentDiskUsageStatistic = this.getCurrentDiskUsageStatistic(timesource, deviceName, hwDistStore);
            if (!this.diskUsageStatisticMap.containsKey(deviceName)) {
                this.diskUsageStatisticMap.putIfAbsent(deviceName, currentDiskUsageStatistic);
                continue;
            }
            DiskUsageStatistic lastObservedDiskUsageStatistic = this.diskUsageStatisticMap.get(deviceName);
            long timeDifference = currentDiskUsageStatistic.getTimestamp() - lastObservedDiskUsageStatistic.getTimestamp();
            if (timeDifference <= 0L) {
                throw new IllegalStateException("Timestamp of new observation should be strictly larger than the previous one.");
            }
            double currentQueue = currentDiskUsageStatistic.getQueue();
            long readBytesDifference = currentDiskUsageStatistic.getReadBytes() - lastObservedDiskUsageStatistic.getReadBytes();
            long readsDifference = currentDiskUsageStatistic.getReads() - lastObservedDiskUsageStatistic.getReads();
            double currentServiceTime = currentDiskUsageStatistic.getServiceTime();
            long writeBytesDifference = currentDiskUsageStatistic.getWriteBytes() - lastObservedDiskUsageStatistic.getWriteBytes();
            long writesDifference = currentDiskUsageStatistic.getWrites() - lastObservedDiskUsageStatistic.getWrites();
            double readBytesPerSecond = (double)readBytesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double readsPerSecond = (double)readsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double writeBytesPerSecond = (double)writeBytesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double writesPerSecond = (double)writesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            DiskUsageRecord diskUsageRecord = new DiskUsageRecord(currentDiskUsageStatistic.getTimestamp(), monitoringController.getHostname(), deviceName, currentQueue, readBytesPerSecond, readsPerSecond, currentServiceTime, writeBytesPerSecond, writesPerSecond);
            monitoringController.newMonitoringRecord(diskUsageRecord);
            this.diskUsageStatisticMap.put(deviceName, currentDiskUsageStatistic);
        }
    }

    private DiskUsageStatistic getCurrentDiskUsageStatistic(ITimeSource timesource, String deviceName, HWDiskStore hwDiskStore) {
        long currentTimestamp = timesource.getTime();
        double queue = hwDiskStore.getCurrentQueueLength();
        long readBytes = hwDiskStore.getReadBytes();
        long reads = hwDiskStore.getReads();
        double serviceTime = hwDiskStore.getTimeStamp();
        long writeBytes = hwDiskStore.getWriteBytes();
        long writes = hwDiskStore.getWrites();
        return new DiskUsageStatistic(currentTimestamp, queue, readBytes, reads, serviceTime, writeBytes, writes);
    }

    static class DiskUsageStatistic {
        private final long timestamp;
        private final double queue;
        private final long readBytes;
        private final long reads;
        private final double serviceTime;
        private final long writeBytes;
        private final long writes;

        public DiskUsageStatistic(long timestamp, double queue, long readBytes, long reads, double serviceTime, long writeBytes, long writes) {
            this.timestamp = timestamp;
            this.queue = queue;
            this.readBytes = readBytes;
            this.reads = reads;
            this.serviceTime = serviceTime;
            this.writeBytes = writeBytes;
            this.writes = writes;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public double getQueue() {
            return this.queue;
        }

        public long getReadBytes() {
            return this.readBytes;
        }

        public long getReads() {
            return this.reads;
        }

        public double getServiceTime() {
            return this.serviceTime;
        }

        public long getWriteBytes() {
            return this.writeBytes;
        }

        public long getWrites() {
            return this.writes;
        }
    }
}

