/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.timer;

import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.monitoring.timer.AbstractTimeSource;

public final class SystemNanoTimer
extends AbstractTimeSource {
    public static final String CONFIG_OFFSET = SystemNanoTimer.class.getName() + ".offset";
    public static final String CONFIG_UNIT = SystemNanoTimer.class.getName() + ".unit";
    private final long offset;
    private final long clockdifference = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    private final TimeUnit timeunit;

    public SystemNanoTimer(Configuration configuration) {
        super(configuration);
        this.offset = configuration.getStringProperty(CONFIG_OFFSET).length() == 0 ? System.nanoTime() : this.clockdifference + configuration.getLongProperty(CONFIG_OFFSET);
        this.timeunit = configuration.getEnumProperty(CONFIG_UNIT, TimeUnit.class, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getTime() {
        return this.timeunit.convert(System.nanoTime() - this.offset, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getOffset() {
        return this.timeunit.convert(this.offset - this.clockdifference, TimeUnit.NANOSECONDS);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeunit;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Time in ").append(this.timeunit.toString().toLowerCase(Locale.ENGLISH)).append(" (with nanoseconds precision) since ").append(new Date(TimeUnit.NANOSECONDS.toMillis(this.offset - this.clockdifference)));
        return sb.toString();
    }
}

