/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.util;

import java.util.LinkedList;
import java.util.List;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;
import kieker.monitoring.core.signaturePattern.PatternParser;
import kieker.monitoring.util.KiekerPattern;
import org.apache.commons.io.FilenameUtils;

public class KiekerPatternUtil {
    public static List<KiekerPattern> getPatterns(String instrumentables) {
        String[] patterns;
        LinkedList<KiekerPattern> patternObjects = new LinkedList<KiekerPattern>();
        for (String pattern : patterns = instrumentables.split(";")) {
            if (pattern.contains("(")) {
                KiekerPatternUtil.parseMethodPattern(patternObjects, pattern);
                continue;
            }
            String clazzName = pattern.substring(pattern.lastIndexOf(" ") + 1);
            KiekerPattern patternObject = new KiekerPattern(clazzName, null);
            patternObjects.add(patternObject);
        }
        return patternObjects;
    }

    private static void parseMethodPattern(List<KiekerPattern> patternObjects, String pattern) {
        String clazzMethodAndPrefix = pattern.substring(0, pattern.indexOf(40));
        String clazzAndPrefix = clazzMethodAndPrefix.substring(0, pattern.lastIndexOf(46));
        String onlyClazz = clazzAndPrefix.contains(" ") ? clazzAndPrefix.substring(clazzAndPrefix.lastIndexOf(32) + 1) : clazzAndPrefix;
        try {
            KiekerPattern patternObject = new KiekerPattern(onlyClazz, PatternParser.parseToPattern(pattern));
            patternObjects.add(patternObject);
        }
        catch (InvalidPatternException e) {
            e.printStackTrace();
        }
    }

    public static boolean classIsContained(List<KiekerPattern> patternObjects, String clazz) {
        for (KiekerPattern pattern : patternObjects) {
            if (clazz.equals(pattern.getOnlyClass())) {
                return true;
            }
            if (!FilenameUtils.wildcardMatch((String)clazz, (String)pattern.getOnlyClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean methodIsContained(List<KiekerPattern> patternObjects, String signature) {
        for (KiekerPattern pattern : patternObjects) {
            if (!pattern.getFullPattern().matcher(signature).matches()) continue;
            return true;
        }
        return false;
    }
}

