/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.print;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintStreamWriter
extends AbstractMonitoringWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintStreamWriter.class);
    private static final String ENCODING = "UTF-8";
    private static final String PREFIX = PrintStreamWriter.class.getName() + ".";
    public static final String STREAM = PREFIX + "Stream";
    public static final String CONFIG_STREAM_STDOUT = "STDOUT";
    public static final String CONFIG_STREAM_STDERR = "STDERR";
    private final String configPrintStreamName;
    private PrintStream printStream;

    public PrintStreamWriter(Configuration configuration) {
        super(configuration);
        this.configPrintStreamName = configuration.getStringProperty(STREAM);
        this.printStream = new PrintStream(new ByteArrayOutputStream());
    }

    @Override
    public void onStarting() {
        if (CONFIG_STREAM_STDOUT.equals(this.configPrintStreamName)) {
            this.printStream = System.out;
        } else if (CONFIG_STREAM_STDERR.equals(this.configPrintStreamName)) {
            this.printStream = System.err;
        } else {
            try {
                this.printStream = new PrintStream((OutputStream)new FileOutputStream(this.configPrintStreamName), false, ENCODING);
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                LOGGER.warn("An exception occurred", e);
            }
        }
    }

    @Override
    public void writeMonitoringRecord(IMonitoringRecord record) {
        this.printStream.println(record.getClass().getSimpleName() + ": " + record.toString());
    }

    @Override
    public void onTerminating() {
        if (this.printStream != System.out && this.printStream != System.err) {
            this.printStream.close();
        }
        LOGGER.info("{} shutting down.", (Object)this.getClass().getName());
    }
}

