/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.analysisComponent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.AnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.analysisComponent.IAnalysisComponent;
import kieker.analysis.exception.InvalidProjectContextException;
import kieker.common.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractAnalysisComponent
implements IAnalysisComponent {
    public static final String CONFIG_NAME = "name-hiddenAndNeverExportedProperty";
    private static final AtomicInteger UNNAMED_COUNTER = new AtomicInteger(0);
    protected final IProjectContext projectContext;
    protected final Configuration configuration;
    protected final Logger logger;
    protected final TimeUnit recordsTimeUnitFromProjectContext;
    private final String name;

    public AbstractAnalysisComponent(Configuration configuration, IProjectContext projectContext) {
        TimeUnit recordTimeunit;
        if (null == projectContext) {
            throw new NullPointerException("Missing projectContext");
        }
        if (null == configuration) {
            throw new NullPointerException("Missing configuration");
        }
        this.projectContext = projectContext;
        configuration.setDefaultConfiguration(this.getDefaultConfiguration());
        this.configuration = configuration;
        if (!(projectContext instanceof AnalysisController)) {
            throw new InvalidProjectContextException("Invalid analysis controller in constructor");
        }
        AnalysisController ac = (AnalysisController)projectContext;
        Object tmpName = configuration.getStringProperty(CONFIG_NAME);
        while (((String)tmpName).length() == 0 || !ac.tryRegisterComponentName((String)tmpName)) {
            tmpName = this.getClass().getSimpleName() + "-" + UNNAMED_COUNTER.incrementAndGet();
        }
        this.name = tmpName;
        this.logger = LoggerFactory.getLogger((String)(this.getClass().getName() + " (" + this.name + ")"));
        String recordTimeunitProperty = projectContext.getProperty("recordsTimeUnit");
        try {
            recordTimeunit = TimeUnit.valueOf(recordTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("{} is no valid TimeUnit! Using NANOSECONDS instead.", (Object)recordTimeunitProperty);
            recordTimeunit = TimeUnit.NANOSECONDS;
        }
        this.recordsTimeUnitFromProjectContext = recordTimeunit;
    }

    protected abstract Configuration getDefaultConfiguration();

    @Override
    public abstract Configuration getCurrentConfiguration();

    @Override
    public final String getName() {
        return this.name;
    }
}

