/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture;

import java.util.Map;
import kieker.analysis.architecture.repository.ModelDescriptor;
import kieker.analysis.architecture.repository.ModelRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class TriggerToModelSnapshotStage<T>
extends AbstractConsumerStage<T> {
    private final OutputPort<ModelRepository> outputPort = this.createOutputPort(ModelRepository.class);
    private final ModelRepository repository;

    public TriggerToModelSnapshotStage(ModelRepository repository) {
        this.repository = repository;
    }

    protected void execute(T element) throws Exception {
        ModelRepository duplicateRepository = new ModelRepository(this.repository.getName());
        for (Map.Entry<EClass, EObject> entry : this.repository.getModels().entrySet()) {
            EObject duplicateModel = EcoreUtil.copy((EObject)entry.getValue());
            ModelDescriptor descriptor = this.repository.getModelDescriptor(entry.getKey());
            duplicateRepository.register(descriptor, duplicateModel);
        }
        this.outputPort.send((Object)duplicateRepository);
    }

    public OutputPort<ModelRepository> getOutputPort() {
        return this.outputPort;
    }
}

