/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.adaptation;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kieker.analysis.architecture.adaptation.IProbeController;
import kieker.analysis.architecture.adaptation.RemoteControlFailedException;
import kieker.analysis.architecture.adaptation.TcpControlConnection;
import kieker.analysis.architecture.adaptation.events.BasicTcpControlEvent;
import kieker.analysis.architecture.adaptation.events.TcpActivationControlEvent;
import kieker.analysis.architecture.adaptation.events.TcpActivationParameterControlEvent;
import kieker.analysis.architecture.adaptation.events.TcpDeactivationControlEvent;
import kieker.common.configuration.Configuration;
import kieker.common.record.remotecontrol.ActivationEvent;
import kieker.common.record.remotecontrol.ActivationParameterEvent;
import kieker.common.record.remotecontrol.AddParameterValueEvent;
import kieker.common.record.remotecontrol.DeactivationEvent;
import kieker.common.record.remotecontrol.IRemoteControlEvent;
import kieker.common.record.remotecontrol.UpdateParameterEvent;
import kieker.monitoring.writer.tcp.ConnectionTimeoutException;
import kieker.monitoring.writer.tcp.SingleSocketTcpWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpProbeController
implements IProbeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpProbeController.class);
    private static final int CONN_TIMEOUT_IN_MS = 100;
    private final Map<String, TcpControlConnection> knownAddresses = new HashMap<String, TcpControlConnection>();

    @Override
    public void controlProbe(BasicTcpControlEvent event) throws RemoteControlFailedException {
        String ip = event.getIp();
        int port = event.getPort();
        String hostname = event.getServiceComponent();
        String pattern = event.getOperationSignature();
        LOGGER.debug("control probe {} {} {}", new Object[]{hostname, ip, port});
        if (event instanceof TcpActivationControlEvent) {
            if (event instanceof TcpActivationParameterControlEvent) {
                this.activateOperationMonitoringWithParameters(ip, port, hostname, pattern, ((TcpActivationParameterControlEvent)event).getParameters());
            } else {
                this.activateOperationMonitoring(ip, port, hostname, pattern);
            }
        } else if (event instanceof TcpDeactivationControlEvent) {
            this.deactivateOperationMonitoring(ip, port, hostname, pattern);
        } else {
            LOGGER.error("Received Unknown TCP control event: {}", (Object)event.getClass().getName());
        }
    }

    public void updateProbeParameter(String ip, int port, String hostname, String pattern, Map<String, List<String>> parameters) throws RemoteControlFailedException {
        for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
            String[] parameterArray = parameter.getValue().toArray(new String[parameter.getValue().size()]);
            this.sendTcpCommand(ip, port, hostname, new UpdateParameterEvent(pattern, parameter.getKey(), parameterArray));
        }
    }

    public void activateOperationMonitoring(String ip, int port, String hostname, String operationSignature) throws RemoteControlFailedException {
        this.sendTcpCommand(ip, port, hostname, new ActivationEvent(operationSignature));
    }

    public void activateOperationMonitoringWithParameters(String ip, int port, String hostname, String operationSignature, Map<String, List<String>> parameters) throws RemoteControlFailedException {
        for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
            this.sendTcpCommand(ip, port, hostname, new ActivationParameterEvent(operationSignature, parameter.getKey(), new String[0]));
            for (String value : parameter.getValue()) {
                this.sendTcpCommand(ip, port, hostname, new AddParameterValueEvent(operationSignature, parameter.getKey(), value));
            }
        }
    }

    public void deactivateOperationMonitoring(String ip, int port, String serviceComponent, String operationSignature) throws RemoteControlFailedException {
        this.sendTcpCommand(ip, port, serviceComponent, new DeactivationEvent(operationSignature));
    }

    private void sendTcpCommand(String ip, int port, String serviceComponent, IRemoteControlEvent monitoringRecord) throws RemoteControlFailedException {
        SingleSocketTcpWriter tcpWriter;
        String writerKey = ip + ":" + port;
        TcpControlConnection currentConnection = this.knownAddresses.get(writerKey);
        if (currentConnection == null || serviceComponent.equals(currentConnection.getServiceComponent())) {
            currentConnection = new TcpControlConnection(ip, port, serviceComponent, this.createNewTcpWriter(ip, port));
            this.knownAddresses.put(writerKey, currentConnection);
        }
        if ((tcpWriter = currentConnection.getTcpWriter()) == null) {
            throw new RemoteControlFailedException("TCP Writer was not found");
        }
        tcpWriter.writeMonitoringRecord(monitoringRecord);
        LOGGER.debug(String.format("Send record %s to %s on port: %d", monitoringRecord.getClass().getName(), ip, port));
    }

    private SingleSocketTcpWriter createNewTcpWriter(String hostname, int port) throws RemoteControlFailedException {
        SingleSocketTcpWriter tcpWriter;
        Configuration configuration = new Configuration();
        configuration.setProperty(SingleSocketTcpWriter.CONFIG_HOSTNAME, hostname);
        configuration.setProperty(SingleSocketTcpWriter.CONFIG_PORT, port);
        configuration.setProperty(SingleSocketTcpWriter.CONFIG_CONN_TIMEOUT_IN_MS, 100);
        configuration.setProperty(SingleSocketTcpWriter.CONFIG_FLUSH, true);
        configuration.setProperty(SingleSocketTcpWriter.CONFIG_BUFFERSIZE, 655350);
        try {
            tcpWriter = new SingleSocketTcpWriter(configuration);
            tcpWriter.onStarting();
        }
        catch (IOException | ConnectionTimeoutException e) {
            LOGGER.debug(String.format("Could not create TCP connections to %s on port %d", hostname, port), (Throwable)e);
            throw new RemoteControlFailedException(String.format("Could not create TCP connections to %s on port %d, writer was not created.", hostname, port), e);
        }
        return tcpWriter;
    }

    public boolean isKnownHost(String ip, int port) {
        return this.knownAddresses.keySet().contains(ip + ":" + port);
    }
}

