/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.dependency;

import java.time.temporal.ChronoUnit;
import java.util.Optional;
import kieker.analysis.architecture.dependency.IDependencyGraphBuilder;
import kieker.analysis.architecture.dependency.ResponseTimeDecorator;
import kieker.analysis.architecture.dependency.VertexType;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.analysis.generic.graph.GraphFactory;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.ExecutionPackage;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.statistics.StatisticRecord;
import kieker.model.analysismodel.statistics.StatisticsModel;
import kieker.model.analysismodel.statistics.StatisticsPackage;

public abstract class AbstractDependencyGraphBuilder
implements IDependencyGraphBuilder {
    public static final String ENTRY_VERTEX_IDENTIFIER = "entry";
    protected IGraph<INode, IEdge> graph;
    protected ResponseTimeDecorator responseTimeDecorator;
    protected ExecutionModel executionModel;
    protected StatisticsModel statisticsModel;

    @Override
    public IGraph<INode, IEdge> build(ModelRepository repository) {
        this.graph = GraphFactory.createGraph(repository.getName());
        this.executionModel = (ExecutionModel)repository.getModel(ExecutionPackage.Literals.EXECUTION_MODEL);
        this.statisticsModel = (StatisticsModel)repository.getModel(StatisticsPackage.Literals.STATISTICS_MODEL);
        this.responseTimeDecorator = new ResponseTimeDecorator(this.statisticsModel, ChronoUnit.NANOS);
        for (Invocation invocation : this.executionModel.getInvocations().values()) {
            this.handleInvocation(invocation);
        }
        return this.graph;
    }

    private void handleInvocation(Invocation invocation) {
        INode sourceVertex = invocation.getCaller() != null ? this.addVertex(invocation.getCaller()) : this.addVertexForEntry();
        INode targetVertex = this.addVertex(invocation.getCallee());
        long calls = (Long)((StatisticRecord)this.statisticsModel.getStatistics().get((Object)invocation)).getProperties().get((Object)"calls");
        this.addEdge(sourceVertex, targetVertex, calls);
    }

    protected abstract INode addVertex(DeployedOperation var1);

    protected INode addVertexForEntry() {
        INode vertex;
        Optional<INode> nodeOptional = this.graph.findNode(ENTRY_VERTEX_IDENTIFIER);
        if (nodeOptional.isPresent()) {
            vertex = nodeOptional.get();
        } else {
            vertex = GraphFactory.createNode(ENTRY_VERTEX_IDENTIFIER);
            this.graph.getGraph().addNode((Object)vertex);
        }
        vertex.setPropertyIfAbsent("type", (Object)VertexType.ENTRY);
        vertex.setProperty("name", ENTRY_VERTEX_IDENTIFIER);
        return vertex;
    }

    protected IEdge addEdge(INode source, INode target, long calls) {
        IEdge edge;
        String edgeId = String.format("%s-%s", source, target);
        Optional<IEdge> edgeOptional = this.graph.findEdge(edgeId);
        if (edgeOptional.isPresent()) {
            edge = edgeOptional.get();
        } else {
            edge = GraphFactory.createEdge(edgeId);
            this.graph.getGraph().addEdge((Object)source, (Object)target, (Object)edge);
        }
        edge.setPropertyIfAbsent("calls", calls);
        return edge;
    }

    protected IGraph<INode, IEdge> addChildGraphIfAbsent(INode node) {
        if (!node.hasChildGraph()) {
            node.createChildGraph();
        }
        return node.getChildGraph();
    }

    protected INode addVertexIfAbsent(IGraph<INode, IEdge> checkGraph, String id) {
        Optional<INode> nodeOptional = checkGraph.findNode(id);
        if (nodeOptional.isPresent()) {
            return nodeOptional.get();
        }
        INode node = GraphFactory.createNode(id);
        checkGraph.getGraph().addNode((Object)node);
        return node;
    }
}

