/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.dependency;

import kieker.analysis.architecture.dependency.AbstractDependencyGraphBuilder;
import kieker.analysis.architecture.dependency.VertexType;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.util.FullyQualifiedNamesFactory;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;

public class DeploymentLevelOperationDependencyGraphBuilder
extends AbstractDependencyGraphBuilder {
    @Override
    protected INode addVertex(DeployedOperation deployedOperation) {
        DeployedOperation operation = deployedOperation;
        DeployedComponent component = operation.getComponent();
        DeploymentContext context = component.getContext();
        INode contextVertex = this.addVertexIfAbsent(this.graph, FullyQualifiedNamesFactory.createFullyQualifiedName(context));
        contextVertex.setPropertyIfAbsent("type", (Object)VertexType.DEPLOYMENT_CONTEXT);
        contextVertex.setPropertyIfAbsent("name", context.getName());
        IGraph<INode, IEdge> contextSubgraph = this.addChildGraphIfAbsent(contextVertex);
        contextSubgraph.setLabel(context.getName());
        INode componentVertex = this.addVertexIfAbsent(contextSubgraph, FullyQualifiedNamesFactory.createFullyQualifiedName(component));
        componentVertex.setPropertyIfAbsent("type", (Object)VertexType.DEPLOYED_COMPONENT);
        componentVertex.setPropertyIfAbsent("name", component.getAssemblyComponent().getComponentType().getName());
        componentVertex.setPropertyIfAbsent("package name", component.getAssemblyComponent().getComponentType().getPackage());
        IGraph<INode, IEdge> componentSubgraph = this.addChildGraphIfAbsent(componentVertex);
        componentSubgraph.setLabel(component.getAssemblyComponent().getComponentType().getName());
        INode operationVertex = this.addVertexIfAbsent(componentSubgraph, FullyQualifiedNamesFactory.createFullyQualifiedName(operation));
        operationVertex.setPropertyIfAbsent("type", (Object)VertexType.DEPLOYED_OPERATION);
        operationVertex.setPropertyIfAbsent("name", operation.getAssemblyOperation().getOperationType().getName());
        operationVertex.setPropertyIfAbsent("return type", operation.getAssemblyOperation().getOperationType().getReturnType());
        operationVertex.setPropertyIfAbsent("modifiers", operation.getAssemblyOperation().getOperationType().getModifiers());
        operationVertex.setPropertyIfAbsent("parameter types", operation.getAssemblyOperation().getOperationType().getParameterTypes());
        this.responseTimeDecorator.decorate(operationVertex, operation);
        return operationVertex;
    }
}

